% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathwayAnalysis.R
\name{pathwayAnalysis}
\alias{pathwayAnalysis}
\title{Metabolic Pathway Analysis of RNAseq Data}
\usage{
pathwayAnalysis(
    DEGpath,
    genename,
    sampsize,
    iters = 1e+05,
    headers = c("log2FoldChange", "padj")
)
}
\arguments{
\item{DEGpath}{character, the path to a txt or csv DEG file}

\item{genename}{character, column name with HUGO Gene Names in DEG file}

\item{sampsize}{numeric, the sample size of the experiment to be analyzed}

\item{iters}{numeric, the number of iterations of resampling to perform in
bootstrapping}

\item{headers}{character vector of length2 in the form c(log fold change
col name, adjusted p value col name)}
}
\value{
pathwayAnalysis() returns a dataframe of pathway scores and pvals
}
\description{
Metabolic Pathway Analysis of RNAseq Data
}
\examples{
#iterations (iters) of resampling in bootstraping set to 30,000 for speed
#100,000 iterations recommended for improved power

set.seed(1234)

scores <- pathwayAnalysis(
                DEGpath = system.file("extdata/BRCA_DEGS.csv",
                                        package = "MetaPhOR"),
                genename = "X",
                sampsize = 1095,
                iters = 30000,
                headers = c("logFC", "adj.P.Val"))
scores
}
