% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_by_quantile.R
\name{filter_genes_zero_expression}
\alias{filter_genes_zero_expression}
\title{Remove genes with gene expression level equal to 0 in a
substantial percentage of the samples}
\usage{
filter_genes_zero_expression(exp, max.samples.percentage = 0.25)
}
\arguments{
\item{exp}{Gene expression matrix or SumarizedExperiment object}

\item{max.samples.percentage}{Max percentage of samples with gene
expression as 0, for genes to be selected.
If max.samples.percentage 100, remove genes with 0 for 100\% samples.
If max.samples.percentage 25, remove genes with 0 for more
than 25\% of the samples.}
}
\value{
A subset of the original matrix only with the rows
passing the filter threshold.
}
\description{
Remove genes with gene expression level equal to 0 in a
substantial percentage of the samples
}
