% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_stratified_model.R
\name{plot_stratified_model}
\alias{plot_stratified_model}
\title{Plot stratified model results}
\usage{
plot_stratified_model(
  triplet.results,
  dnam,
  exp,
  metadata,
  label.dnam = "beta-value",
  label.exp = "expression",
  tf.activity.es = NULL,
  dnam.group.threshold = 0.25
)
}
\arguments{
\item{triplet.results}{Output from function stratified_model
with Region ID, TF  (column name: TF),  and target gene  (column name: target),
p-values and estimates of interaction}

\item{dnam}{DNA methylation matrix  or SummarizedExperiment object
(columns: samples same order as met, rows: regions/probes)}

\item{exp}{A gene expression matrix or SummarizedExperiment object
(columns: samples same order as met, rows: genes)}

\item{metadata}{A data frame with samples as row names and one columns that will be used to
color the samples}

\item{label.dnam}{Used for label text. Option "beta-value" and "residuals"}

\item{label.exp}{Used for label text. Option "expression" and "residuals"}

\item{tf.activity.es}{A matrix with normalized enrichment scores for each TF across all samples
to be used in linear models instead of TF gene expression.}

\item{dnam.group.threshold}{DNA methylation threshold percentage to define samples 
in the low methylated group and high methylated group. For example, 
setting the threshold to 0.3 (30\%) will assign samples with the lowest 30\% 
methylation in the low group and the highest 30\% methylation in the high group. 
Default is 0.25 (25\%), accepted threshold range (0.0,0.5].}
}
\value{
A ggplot object, includes a table with results from fitting stratified model,
and the following scatter plots: 1) TF vs DNAm, 2) Target vs DNAm,
3) Target vs TF, 4) Target vs TF for samples in Q1 and Q4 for DNA methylation,
5) Target vs DNAm for samples in Q1 and Q4 for the TF
}
\description{
Create several plots to show interaction data
TF expression with target gene interaction using a linear model
\deqn{log2(RNA target) ~ log2(TF)}
to samples with highest DNAm values (top 25 percent) and lowest DNAm values (bottom 25 percent), separately.
}
