% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_cal_pcoa.R
\name{get_pcoa}
\alias{get_pcoa}
\alias{get_pcoa.data.frame}
\alias{get_pcoa.dist}
\alias{get_pcoa.phyloseq}
\title{performs principal coordinate analysis (PCoA)}
\usage{
get_pcoa(obj, ...)

\method{get_pcoa}{data.frame}(
  obj,
  distmethod = "euclidean",
  taxa_are_rows = FALSE,
  sampleda = NULL,
  tree = NULL,
  method = "hellinger",
  ...
)

\method{get_pcoa}{dist}(
  obj,
  distmethod,
  data = NULL,
  sampleda = NULL,
  method = "hellinger",
  ...
)

\method{get_pcoa}{phyloseq}(obj, distmethod = "euclidean", ...)
}
\arguments{
\item{obj}{phyloseq, the phyloseq class or dist class.}

\item{..., }{additional parameter, see also
\code{\link[MicrobiotaProcess]{get_dist}}.}

\item{distmethod}{character, the method of distance, 
see also \code{\link[phyloseq]{distance}}}

\item{taxa_are_rows}{logical, if feature of data is column, 
it should be set FALSE.}

\item{sampleda}{data.frame, nrow sample * ncol factor, default is NULL.}

\item{tree}{phylo, the phylo class, default is NULL, 
when use unifrac method, it should be required.}

\item{method}{character, the standardization method for 
community ecologists, default is hellinger, if the data 
has be normlized, it shound be set NULL.}

\item{data}{data.frame, numeric data.frame nrow sample * ncol features.}
}
\value{
pcasample object, contained prcomp or 
pcoa and sampleda (data.frame).
}
\description{
performs principal coordinate analysis (PCoA)
}
\examples{
\dontrun{
    library(phyloseq)
    data(GlobalPatterns)
    subGlobal <- subset_samples(GlobalPatterns, 
                  SampleType \%in\% c("Feces", "Mock", "Ocean", "Skin"))
    pcoares <- get_pcoa(subGlobal, 
                       distmethod="euclidean",
                       method="hellinger")
    pcoaplot <- ggordpoint(pcoares, biplot=FALSE,
                            speciesannot=FALSE,
                            factorNames=c("SampleType"), 
                            ellipse=FALSE)
}
}
\author{
Shuangbin Xu
}
