% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_rrarefy.R
\docType{methods}
\name{mp_rrarefy}
\alias{mp_rrarefy}
\alias{mp_rrarefy,MPSE-method}
\alias{mp_rrarefy,MPSE}
\alias{mp_rrarefy,tbl_mpse-method}
\alias{mp_rrarefy,tbl_mpse}
\alias{mp_rrarefy,grouped_df_mpse-method}
\alias{mp_rrarefy,grouped_df_mpse}
\title{mp_rrarefy method}
\usage{
mp_rrarefy(
  .data,
  .abundance = NULL,
  raresize,
  trimOTU = FALSE,
  trimSample = FALSE,
  seed = 123,
  ...
)

\S4method{mp_rrarefy}{MPSE}(
  .data,
  .abundance = NULL,
  raresize,
  trimOTU = FALSE,
  trimSample = FALSE,
  seed = 123,
  ...
)

\S4method{mp_rrarefy}{tbl_mpse}(
  .data,
  .abundance = NULL,
  raresize,
  trimOTU = FALSE,
  trimSample = FALSE,
  seed = 123,
  ...
)

\S4method{mp_rrarefy}{grouped_df_mpse}(
  .data,
  .abundance = NULL,
  raresize,
  trimOTU = FALSE,
  trimSample = FALSE,
  seed = 123,
  ...
)
}
\arguments{
\item{.data}{MPSE or tbl_mpse object}

\item{.abundance}{the name of OTU(feature) abundance column,
default is Abundance.}

\item{raresize}{integer Subsample size for rarefying community.}

\item{trimOTU}{logical Whether to remove the otus that are no 
longer present in any sample after rarefaction}

\item{trimSample}{logical whether to remove the samples that 
do not have enough abundance (raresize), default is FALSE.}

\item{seed}{a random seed to make the rrarefy reproducible,
default is 123.}

\item{...}{additional parameters, meaningless now.}
}
\value{
update object
}
\description{
mp_rrarefy method
}
\examples{
data(mouse.time.mpse)
mouse.time.mpse \%>\% mp_rrarefy()
}
\seealso{
[mp_extract_assays()] and [mp_decostand()]
}
\author{
Shuangbin Xu
}
