% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/Modstrings-seqtype.R
\name{shortName}
\alias{shortName}
\alias{fullName}
\alias{nomenclature}
\alias{alphabet}
\alias{alphabet,ModString-method}
\alias{alphabet,ModStringSet-method}
\alias{shortName,ModString-method}
\alias{shortName,ModStringSet-method}
\alias{fullName,ModString-method}
\alias{fullName,ModStringSet-method}
\alias{nomenclature,ModString-method}
\alias{nomenclature,ModStringSet-method}
\title{Base information for sequence characters of nucleotide strings 
containing modifications}
\usage{
shortName(x)

fullName(x)

nomenclature(x)

\S4method{alphabet}{ModString}(x, baseOnly = FALSE)

\S4method{alphabet}{ModStringSet}(x, baseOnly = FALSE)

\S4method{shortName}{ModString}(x)

\S4method{shortName}{ModStringSet}(x)

\S4method{fullName}{ModString}(x)

\S4method{fullName}{ModStringSet}(x)

\S4method{nomenclature}{ModString}(x)

\S4method{nomenclature}{ModStringSet}(x)
}
\arguments{
\item{x}{a \code{ModString} or \code{ModStringSet} object}

\item{baseOnly}{\code{TRUE} or \code{FALSE} (default): Should the result omit
occurances of the letters \code{N.-+}?}
}
\value{
a character vector.
}
\description{
The \code{alphabet()}, \code{shortName()} \code{fullName()} and
\code{nomenclature()} functions return the letters, names and associated
abbreviations for the type of ModString. \code{alphabet()} returns the normal
letters and modification letters, whereas \code{shortName()},
\code{fullName()} and \code{nomenclature()} return results for modifications
only.
}
\examples{
alphabet(ModDNAString())
shortName(ModDNAString())
nomenclature(ModDNAString())
}
