% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Modstrings-replaceLetterAt.R
\name{replaceLetterAt}
\alias{replaceLetterAt}
\alias{replaceLetterAt,ModString-method}
\alias{replaceLetterAt,ModStringSet-method}
\title{Replacing letters in a nucleotide sequence (or set of nucleotide 
sequences) at some specified locations containing nucleotide modifications}
\usage{
\S4method{replaceLetterAt}{ModString}(x, at, letter, verbose = FALSE)

\S4method{replaceLetterAt}{ModStringSet}(x, at, letter, verbose = FALSE)
}
\arguments{
\item{x}{a \code{\link{ModString}} or \code{\link{ModStringSet}} object}

\item{at}{the location where the replacement should be made.

The same input as in \code{\link[Biostrings]{replaceLetterAt}} are expected:

If x is a \code{\link{ModString}} object, then at is typically an integer
vector with no NAs but a logical vector or Rle object is valid too. Locations
can be repeated and in this case the last replacement to occur at a given
location prevails.

If x is a rectangular \code{\link{ModStringSet}} object, then \code{at} must
be a matrix of logicals with the same dimensions as x. If the
\code{\link{ModStringSet}} is not rectangular, \code{at} must be a list of
logical vectors.}

\item{letter}{The new letters.

The same input as in \code{\link[Biostrings]{replaceLetterAt}} are expected:

If x is a \code{\link{ModString}} object, then letter must be a 
\code{\link{ModString}} object or a character vector (with no NAs) with a 
total number of letters (sum(nchar(letter))) equal to the number of locations
specified in at.

If x is a rectangular \code{\link{ModStringSet}} object, then letter must be
a \code{\link{ModStringSet}} object or a character vector of the same length
as x. In addition, the number of letters in each element of letter must match
the number of locations specified in the corresponding row of at
(all(width(letter) == rowSums(at))).}

\item{verbose}{See \code{\link[Biostrings]{replaceLetterAt}}.}
}
\value{
the input \code{\link{ModString}} or \code{\link{ModStringSet}}
object with the changes applied
}
\description{
\code{replaceLetterAt} replaces a letter in a \code{\link{ModString}} objects
with a new letter. In contrast to \code{\link{modifyNucleotides}} it does not
check the letter to be replaced for its identity, it just replaces it and 
behaves exactly like the
}
\examples{
# Replacing the last two letters in a ModDNAString
seq1 <- ModDNAString("AGTC")
seq
seq2 <- replaceLetterAt(seq1,c(3,4),"CT")
seq2

# Now containg and m3C
seq2 <- replaceLetterAt(seq1,c(3,4),ModDNAString("/T"))
seq2

# Replacing the last two letters in a set of sequences
set1 <- ModDNAStringSet(c("AGTC","AGTC"))
set1

set2 <- replaceLetterAt(set1,
                          matrix(rep(c(FALSE,FALSE,TRUE,TRUE),2),
                                 nrow = 2,
                                 byrow = TRUE),
                          c("CT","CT"))
set2
}
