% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TFinfluence.R
\name{TFinfluence}
\alias{TFinfluence}
\title{TFinfluence}
\usage{
TFinfluence(
  dataPRA,
  dataDEGs,
  dataTRRUST,
  dataMAF,
  dataMAVISp,
  stabClassMAVISp = "rasp"
)
}
\arguments{
\item{dataPRA}{Output PRA function. List of TSG and OCG
Must contain the following elements
\itemize{
\item TSG (The TSGs identified by moonlight along with the moonlight score)
\item OCG (The OCGs identified by moonlight along with the moonlight score)
}}

\item{dataDEGs}{Output DEA function. Tibble containing differentially expressed genes.
Must contain the following columns
\itemize{
\item GENE (HUGO symbol of DEG)
\item logFC (The log fold change of DEG)
}}

\item{dataTRRUST}{Tibble containing gene-TF pairs and type of interaction
Must contain the following columns:
\itemize{
\item TF (HUGO symbol of TF)
\item Target (HUGO symbol of target gene of TF)
\item InteractionType (The effect the TF has on the target gene (Activation, Repression))
}}

\item{dataMAF}{Tibble containing mutation info from MAF
Must at least contain the following columns:
\itemize{
\item Hugo_Symbol eg. BRCA1
\item HGVSp_Short eg. p.V83F
}}

\item{dataMAVISp}{Output loadMAVISp function. List of tibbles, one for each protein.
The tibbles must contain at least
\itemize{
\item (First column must contain the mutation (e.g. A54W). It is assumed that the column name is empty)
}
Then the tibbles must contain columns mathing either of the following names(or they will be excluded) 
\itemize{
\item (Stability classification, [A-Za-z0-9]+, \\(Rosetta, FoldX\\)) (Values: Stabilizing, Neutral, Destabilizing, Uncertain)
\item (Stability classification, [A-Za-z0-9]+, \\(RaSP, FoldX\\)) (Values: Stabilizing, Neutral, Destabilizing, Uncertain)
}}

\item{stabClassMAVISp}{The protocol to use for mutation stability classification. Default is rasp.
Accepts one of the following strings
\itemize{
\item rosetta (uses the FoldX/Rosetta protocol)
\item rasp (uses the FoldX/RaSP protocol)
}}
}
\value{
returns a tibble containing:
\itemize{
\item GENE
\item TF 
\item InteractionType 
\item PMID
\item tf_mutation
\item stab_class (the effect on stability as classified by MAVISp)
}
}
\description{
This function finds mutations in the transcription factors (TF) of the DEGs that have a TF in the database.
}
\examples{

data('dataPRA')
data('DEGsmatrix')
data('dataTRRUST')
data('dataMAF')
data('dataMAVISp')

TFinfluence(dataTRRUST = dataTRRUST,
           dataMAF = dataMAF,
           dataDEGs = DEGsmatrix,
           dataPRA = dataPRA,
           dataMAVISp = dataMAVISp,
           stabClassMAVISp = 'rasp')

}
