## ----eval = FALSE-------------------------------------------------------------
# # Install latest version of MotifPeeker
# BiocManager::install("MotifPeeker", version = "devel", dependencies = TRUE)
# 
# # Load the package
# library(MotifPeeker)

## ----load-package-------------------------------------------------------------
library(MotifPeeker)

## ----load-data----------------------------------------------------------------
## Peak files processed using read_peak_file()
data("CTCF_ChIP_peaks", package = "MotifPeeker")
data("CTCF_TIP_peaks", package = "MotifPeeker")

## Motif files processed using read_motif_file()
data("motif_MA1102.3", package = "MotifPeeker")
data("motif_MA1930.2", package = "MotifPeeker")

## ----eval = FALSE-------------------------------------------------------------
# ## MACS2/3 peak files
# peak_files <- list("/path/to/peak1.narrowPeak", "/path/to/peak2.narrowPeak")
# 
# ## or SEACR peak files
# peak_files <- list("/path/to/peak1.bed", "/path/to/peak2.bed")

## ----prepare-peak-files-------------------------------------------------------
peak_files <- list(CTCF_ChIP_peaks, CTCF_TIP_peaks)

## ----prepare-alignment-files--------------------------------------------------
## Alignment files
CTCF_ChIP_alignment <- system.file("extdata", "CTCF_ChIP_alignment.bam",
                                    package = "MotifPeeker")
CTCF_TIP_alignment <- system.file("extdata", "CTCF_TIP_alignment.bam",
                                    package = "MotifPeeker")

alignment_files <- list(CTCF_ChIP_alignment, CTCF_TIP_alignment)

## ----prepare-genome-build-----------------------------------------------------
## BSgenome object
genome_build <- BSgenome.Hsapiens.UCSC.hg38::BSgenome.Hsapiens.UCSC.hg38

## ----eval = FALSE-------------------------------------------------------------
# genome_build <- "hg38"  # Other abbreviations: "hg19", "mm10", "mm39"

## ----eval = FALSE-------------------------------------------------------------
# ## JASPAR motif files
# motif_files <- list("/path/to/motif1.jaspar", "/path/to/motif2.jaspar")

## ----prepare-motif-files------------------------------------------------------
motif_files <- list(motif_MA1102.3, motif_MA1930.2)

## ----run-motifpeeker, eval = FALSE--------------------------------------------
# if (MotifPeeker:::confirm_meme_install(continue = TRUE)) {
#     MotifPeeker(
#         peak_files = peak_files,
#         reference_index = 2,  # Set TIP-seq experiment as reference
#         alignment_files = alignment_files,
#         exp_labels = c("ChIP", "TIP"),
#         exp_type = c("chipseq", "tipseq"),
#         genome_build = genome_build,
#         motif_files = motif_files,
#         cell_counts = NULL,  # No cell-count information
#         distance_bootstrap = TRUE,
#         bootstrap_n = NULL,
#         bootstrap_len = NULL,
#         motif_discovery = TRUE,
#         motif_discovery_count = 3,  # Discover top 3 motifs
#         motif_db = NULL,  # Use default motif database (JASPAR)
#         download_buttons = TRUE,
#         out_dir = tempdir(),  # Save output in a temporary directory
#         BPPARAM = BiocParallel::SerialParam(),  # Use two CPU cores on a 16GB RAM machine
#         debug = FALSE,
#         quiet = TRUE,
#         verbose = TRUE
#     )
# }

## ----session-info-------------------------------------------------------------
utils::sessionInfo()

