% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dt_enrichment_individual.R
\name{dt_enrichment_individual}
\alias{dt_enrichment_individual}
\title{Get \code{\link[DT]{datatable}} for motif-enrichment of individual
experiments.}
\usage{
dt_enrichment_individual(
  result,
  enrichment_df,
  comparison_i,
  motif_i,
  reference_index = 1
)
}
\arguments{
\item{result}{A \code{list} with the following elements:
\describe{
    \item{peaks}{A \code{list} of peak files generated using
\code{\link{read_peak_file}}.}
    \item{alignments}{A \code{list} of alignment files.}
    \item{exp_type}{A \code{character} vector of experiment types.}
    \item{exp_labels}{A \code{character} vector of experiment labels.}
    \item{read_count}{A \code{numeric} vector of read counts.}
    \item{peak_count}{A \code{numeric} vector of peak counts.}
}}

\item{enrichment_df}{A data frame containing the motif enrichment results,
produced using \code{\link{get_df_enrichment}}.}

\item{comparison_i}{The index of the comparison dataset to plot.}

\item{motif_i}{The index of the motif to plot.}

\item{reference_index}{An integer specifying the index of the peak file to
use as the reference dataset for comparison. Indexing starts from 1.
(default = 1)}
}
\value{
A \code{DT::datatable} object with the peak motif enrichment data
for the specified \code{comparison_i} and \code{motif_i}.
}
\description{
Get \code{\link[DT]{datatable}} for motif-enrichment of individual
experiments.
}
\seealso{
Other datatable functions: 
\code{\link{print_denovo_sections}()}
}
\concept{datatable functions}
\keyword{internal}
