% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segregate_seqs.R
\name{segregate_seqs}
\alias{segregate_seqs}
\title{Segregate input sequences into common and unique groups}
\usage{
segregate_seqs(seqs1, seqs2)
}
\arguments{
\item{seqs1}{A set of sequences (\code{GRanges} object)}

\item{seqs2}{A set of sequences (\code{GRanges} object)}
}
\value{
A list containing the common sequences and unique sequences for each
set of sequences. The list contains the following \code{GRanges} objects:
\itemize{
    \item \code{common_seqs1}: Common sequences in \code{seqs1}
    \item \code{common_seqs2}: Common sequences in \code{seqs2}
    \item \code{unique_seqs1}: Unique sequences in \code{seqs1}
    \item \code{unique_seqs2}: Unique sequences in \code{seqs2}
}
}
\description{
This function takes two sets of sequences and segregates them into common and
unique sequences. The common sequences are sequences that are present in both
sets of sequences. The unique sequences are sequences that are present in
only one of the sets of sequences.
}
\details{
Sequences are considered common if their base pairs align in any
position, even if they vary in length. Consequently, while the number of
common sequences remains consistent between both sets, but the length and
composition of these sequences may differ. As a result, the function returns
distinct sets of common sequences for each input set of sequences.
}
\examples{
data("CTCF_ChIP_peaks", package = "MotifPeeker")
data("CTCF_TIP_peaks", package = "MotifPeeker")

seqs1 <- CTCF_ChIP_peaks
seqs2 <- CTCF_TIP_peaks
res <- segregate_seqs(seqs1, seqs2)
print(res)

}
\seealso{
\link[GenomicRanges]{findOverlaps}
}
