% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AbundanceSimilarityParam.R
\docType{class}
\name{groupFeatures-similar-abundance}
\alias{groupFeatures-similar-abundance}
\alias{AbundanceSimilarityParam}
\alias{groupFeatures,matrix,AbundanceSimilarityParam-method}
\alias{groupFeatures,SummarizedExperiment,AbundanceSimilarityParam-method}
\title{Group features based on abundance similarities across samples}
\usage{
AbundanceSimilarityParam(
  threshold = 0.9,
  simFun = corRows,
  groupFun = groupSimilarityMatrix,
  subset = integer(),
  transform = identity,
  ...
)

\S4method{groupFeatures}{matrix,AbundanceSimilarityParam}(object, param, ...)

\S4method{groupFeatures}{SummarizedExperiment,AbundanceSimilarityParam}(object, param, i = 1L, ...)
}
\arguments{
\item{threshold}{\code{numeric(1)} defining the (similarity) threshold to be used
for the feature grouping. This parameter is passed to the \code{groupFun}
function.}

\item{simFun}{\code{function} to be used to calculate (pairwise)
similarities (between \strong{rows}). Defaults to \code{simFun = corRows}.
See description or \code{\link[=corRows]{corRows()}} for more details.}

\item{groupFun}{\code{function} to group features based on the calculated
similarity matrix. Defaults to \code{groupFun = groupSimilarityMatrix}. See
\code{\link[=groupSimilarityMatrix]{groupSimilarityMatrix()}} for details.}

\item{subset}{\code{integer} or \code{logical} defining a subset of samples (at least
2) on which the similarity calculation should be performed. By default
the calculation is performed on all samples.}

\item{transform}{\code{function} to be used to transform feature abundances prior
to the similarity calculation. Defaults to \code{transform = identity}.
Alternatively, values could e.g. transformed into log2 scale with
\code{transform = log2}.}

\item{...}{for \code{AbundanceSimilarityParam}: optional parameters to be passed
along to \code{simFun} and \code{groupFun}. For \code{groupFeatures}: optional
parameters for the extraction/definition of the feature values from
\code{object}.}

\item{object}{object containing the feature abundances on which features
should be grouped.}

\item{param}{\code{AbundanceSimilarityParam} defining the settings for the
grouping based on feature values.}

\item{i}{for \code{object} being a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment::SummarizedExperiment()}}: \code{integer(1)} or
\code{character(1)} specifying either the index or name of the  the \emph{assay}
in \code{object} that contains the feature values that should be used. Use
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment::assayNames()}} on \code{object} to list all available
assays.}
}
\value{
for object being a \code{SummarizedExperiment}: a \code{SummarizedExperiment}
with the grouping results added to a column \code{"feature_group"} in the
object's \code{rowData}. For object being a \code{matrix}: an \code{integer} of length
equal to the number of rows with the group identifiers.
}
\description{
Group features based on similar abundances (i.e. \emph{feature values}) across
samples. Parameter \code{subset} allows to define a sub set of samples on which
the similarity calculation should be performed. It might for example be
better to exclude QC samples from the analysis because feature values  are
supposed to be constant in these samples.

The function first calculates a nxn similarity matrix with n being the
number of features and subsequently groups features for which the similarity
is higher than the user provided threshold. Parameter \code{simFun} allows
to specify the function to calculate the pairwise similarities on the feature
values (eventually transformed by the function specified with parameter
\code{transform}). \code{simFun} defaults to a function that uses \code{cor} to calculate
similarities between rows in \code{object} but any function that calculates
similarities between rows and that returns a (symmetric) numeric similarity
matrix can be used.

If \code{object} is a \code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment::SummarizedExperiment()}}: if a
column \code{"feature_group"} is
found in \code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment::colData()}} feature groups defined in that
column are further sub-grouped with this method. See \code{\link[=groupFeatures]{groupFeatures()}} for
the general concept of this feature grouping.

Parameter \code{groupFun} allows to specify the function to group the features
based on the similarity function. It defaults to \code{groupSimilarityMatrix}. See
\code{\link[=groupSimilarityMatrix]{groupSimilarityMatrix()}} for details.

Additional settings for the \code{groupFun} and \code{simFun} functions can be passed
to the \strong{parameter object}  with the \code{...} in the \code{AbundanceSimilarityParam}
constructor function. Other additional parameters specific for the type
of \code{object} can be passed \emph{via} \code{...} in the \code{groupFeatures} call.
}
\examples{

## Define a simple numeric matrix on which we want to group the rows
x <- rbind(
    c(12, 34, 231, 234, 9, 5, 7),
    c(900, 900, 800, 10, 12, 9, 4),
    c(25, 70, 400, 409, 15, 8, 4),
    c(12, 13, 14, 15, 16, 17, 18),
    c(14, 36, 240, 239, 12, 7, 8),
    c(100, 103, 80, 2, 3, 1, 1)
    )

## Group rows based on similarity calculated with Pearson's correlation
## on the actual data values (without transforming them).
res <- groupFeatures(x, AbundanceSimilarityParam())
res

## Use Spearman's rho to correlate rows of the log2 transformed x matrix
res <- groupFeatures(x, AbundanceSimilarityParam(method = "spearman",
    transform = log2))
res

## Perform the grouping on a SummarizedExperiment
library(SummarizedExperiment)
data(se)

## Group features based on log2 transformed feature values in the first
## assay of the SummarizedExperiment
res <- groupFeatures(se, param = AbundanceSimilarityParam(threshold = 0.7,
    transform = log2))

featureGroups(res)

## Perform feature grouping only on a subset of rows/features:
featureGroups(res) <- NA_character_
featureGroups(res)[40:80] <- "FG"
res <- groupFeatures(res, AbundanceSimilarityParam(transform = log2))
featureGroups(res)
}
\seealso{
\code{\link[=groupFeatures]{groupFeatures()}} for the general concept of feature grouping.

\code{\link[=featureGroups]{featureGroups()}} for the function to extract defined feature
groups from a \code{SummarizedExperiment}.

Other feature grouping methods: 
\code{\link{groupFeatures-similar-rtime}}
}
\author{
Johannes Rainer
}
\concept{feature grouping methods}
