% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_ResultSet-ClassGenerics.R
\name{getAssociation}
\alias{getAssociation}
\title{Method to extrat feature result from a ResultSet}
\usage{
getAssociation(object, rid = 1, coef = 2, contrast = NULL, fNames = NULL, ...)
}
\arguments{
\item{object}{A \code{\link{ResultSet}} object.}

\item{rid}{The name or index of the result to be extracted.}

\item{coef}{(default \code{2}) Index of the coefficient to be extracted.}

\item{contrast}{(default \code{1}) When \code{code} corresponds to a
multicategorical variable, contasr selects the comparison.}

\item{fNames}{(default \code{c("chromosome", "start", "end", "genesymbol")})
Corresponds to the columns selected from \code{fData} that will be
incorporated into the resulting \code{data.frame}.}

\item{...}{Further arguments passed to \link[limma]{topTable}}
}
\value{
A \code{data.frame} with the result of the association study,
including P-Value and Fold Change.
}
\description{
Homologous methods from \code{limma}, \code{getAssociation} resturns a
\code{data.frame} with the \code{logFC} and  \code{PValue} per
featrue for the selcted \code{coef} and for given result (\code{rid}).
}
\examples{
data(rset)
getAssociation(rset, rid=1, fNames = c("chromosome", "position"))
}
