% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEanalysisTimeAndGroup.R
\name{DEanalysisTimeAndGroup}
\alias{DEanalysisTimeAndGroup}
\title{DE analysis when samples belong to different biological condition
and time points.}
\usage{
DEanalysisTimeAndGroup(
  DESeq.result,
  LRT.supp.info = TRUE,
  log.FC.min,
  pval.min,
  pval.vect.t,
  Plot.DE.graph = TRUE,
  path.result,
  SubFile.name
)
}
\arguments{
\item{DESeq.result}{Output from the function
\code{\link[DESeq2:DESeq]{DESeq2::DESeq()}}.}

\item{LRT.supp.info}{\code{TRUE} or \code{FALSE}.
If \code{TRUE}, the algorithm realizes another statistical test in order
to detect if, among all biological conditions and/or times, at least one has
a different behavior than the others (see the input \code{test} in
\code{\link[DESeq2:DESeq]{DESeq2::DESeq()}}).}

\item{log.FC.min}{Non negative numeric value.
If the log2 fold change between biological conditions or times has an
absolute value below the threshold \code{log.FC.min}, then the gene is
not selected even if is considered as DE. Default value is 1.
If \code{log.FC.min=0}, all DE genes will be kept.}

\item{pval.min}{Numeric value between 0 and 1. A gene will be considered as
differentially expressed (DE) between two biological conditions
if its Benjamini-Hochberg adjusted p-value
(see \code{\link[stats:p.adjust]{stats::p.adjust()}})
is below the threshold \code{pval.min}. Default value is 0.05}

\item{pval.vect.t}{\code{NULL} or vector of dimension \eqn{T-1}
filled with numeric values between 0 and 1,
with \eqn{T} the number of time measurements.
A gene will be considered as differentially expressed (DE) between the
time ti and the reference time t0 if its Benjamini-Hochberg adjusted p-value
(see \code{\link[stats:p.adjust]{stats::p.adjust()}})
is below the i-th threshold of \code{pval.vect.t}.
If NULL, \code{pval.vect.t} will be vector of dimension \eqn{T-1} filled
with \code{pval.min}.}

\item{Plot.DE.graph}{\code{TRUE} or \code{FALSE}. \code{TRUE} as default.
If \code{TRUE}, all graphs will be plotted.
Otherwise no graph will be plotted.}

\item{path.result}{Character or \code{NULL}.
If \code{path.result} is a character, it must be a path to a folder,
all graphs will be saved in different sub-folders in \code{path.result}.
If \code{NULL}, the results will not be saved. \code{NULL} as default.}

\item{SubFile.name}{Character or \code{NULL}.
If \code{SubFile.name} is a character, each saved file names and
created folders names will contain the strings of characters
"_\code{SubFile.name}". If \code{NULL}, no suffix will be added.}
}
\value{
The function returns the same DESeqDataSet class object
\code{DESeq.result} with the following results,
saved in the metadata \code{DEresultsTimeGroup} of \code{DESeq.result}:
\itemize{
\item a data.frame (output \code{DEsummary} of \code{DEresultsTimeGroup})
which contains
\itemize{
\item gene names
\item Results from the temporal statistical analysis
\itemize{
\item pvalues, log2 fold change and DE genes between each pairs of
biological conditions for each fixed time.
\item \eqn{N_{bc}} binary columns (0 and 1), one per biological condition
(with \eqn{N_{bc}} the number of biological conditions).
A 1 in one of these two columns means the gene is DE at least between
one time ti versus the reference time t0, for the biological condition
associated to the given column.
\item \eqn{N_{bc}} columns, one per biological condition, where each element
is succession of 0 and 1. The positions of 1 in one of these two columns,
indicate the set of times ti such that the gene is DE between ti and
the reference time t0, for the biological condition associated to
the given column.
}
\item Results from the statistical analysis by biological condition
\itemize{
\item pvalues, log2 fold change and DE genes between each time ti
and the reference time t0 for each biological condition.
\item \eqn{T} binary columns (0 and 1), one per time
(with \eqn{T} the number of time measurements).
A 1 in one of these columns, means the gene is DE between at least
one pair of biological conditions, for the fixed time associated
to the given column.
\item \eqn{T \times N_{bc}} binary columns, which give the genes specific
for each biological condition at each time ti.
A 1 in one of these columns means the gene is specific to the biological
condition at a fixed time associated to the given column. 0 otherwise.
A gene is called specific to a given biological condition BC1 at a
time ti, if the gene is DE between BC1 and any other biological
conditions at time ti, but not DE between any pair of other biological
conditions at time ti.
\item \eqn{T \times N_{bc}} columns filled with -1, 0 and 1.
A 1 in one of these columns means the gene is up-regulated
(or over-expressed) for the biological condition at a fixed time
associated to the given column. A gene is called up-regulated for a
given biological condition BC1 at time ti if the gene is specific to
the biological condition BC1 at time ti and expressions in BC1 at time
ti are higher than in the other biological conditions at time ti.
A -1 in one of these columns means the gene is down-regulated
(or under-expressed) for the biological condition at a fixed time
associated to the given column. A gene is called down-regulated for a
given biological condition at a time ti BC1 if the gene is specific to
the biological condition BC1 at time ti and expressions in BC1 at time
ti are lower than in the other biological conditions at time ti.
A 0 in one of these columns means the gene is not specific to the
biological condition at a fixed time associated to the given column.
\item \eqn{N_{bc}} binary columns (0 and 1). A 1 in one of these columns
means the gene is specific at least at one time ti, for the biological
condition associated to the given column. 0 otherwise.
}
\item Results from the combination of temporal and biological statistical
analysis
\itemize{
\item \eqn{T \times N_{bc}} binary columns, which give the signatures genes
for each biological condition at each time ti. A 1 in one of these
columns means the gene is signature gene to the biological condition at
a fixed time associated to the given column. 0 otherwise.
A gene is called signature of a biological condition BC1 at a given time
ti, if the gene is specific to the biological condition BC1 at time ti
and DE between ti versus the reference time t0 for the biological
condition BC1.
\item \eqn{N_{bc}} binary columns (0 and 1). A 1 in one of these columns
means the gene is signature at least at one time ti, for the biological
condition associated to the given column. 0 otherwise.
}
}
\item the following plots from the temporal statistical analysis
\itemize{
\item a barplot which gives the number of DE genes between ti and the
reference time t0, for each time ti (except the reference time t0) and
biological condition
(see \code{\link[=DEplotBarplotFacetGrid]{DEplotBarplotFacetGrid()}}).
\item \eqn{N_{bc}} alluvial graphs of DE genes
(see \code{\link[=DEplotAlluvial]{DEplotAlluvial()}}),
one per biological condition.
\item \eqn{N_{bc}} graphs showing the number of DE genes as a function of time
for each temporal group, one per biological condition. By temporal group,
we mean the sets of genes which are first DE at the same time.
\item \eqn{2\times N_{bc}} UpSet plot showing the number of DE genes
belonging to each DE temporal pattern, for each biological condition.
By temporal pattern, we mean the set of times ti such that the gene is
DE between ti and the reference time t0 (see \code{\link[=DEplotVennBarplotTime]{DEplotVennBarplotTime()}}).
\item an alluvial graph for DE genes which are DE at least one time for
each group.
}
\item the following plots from the statistical analysis by biological condition
\itemize{
\item a barplot which gives the number of specific DE genes for each
biological condition and time (see \code{\link[=DEplotBarplotFacetGrid]{DEplotBarplotFacetGrid()}}).
\item \eqn{N_{bc}(N_{bc}-1)/2} UpSet plot which give the number of genes
for each possible intersection (set of pairs of biological conditions),
one per time (see \code{\link[=DEplotVennBarplotGroup]{DEplotVennBarplotGroup()}}).
\item an alluvial graph of genes which are specific at least one time
(see \code{\link[=DEplotAlluvial]{DEplotAlluvial()}}).
}
\item the following plots from the combination of temporal and biological
statistical analysis
\itemize{
\item a barplot which gives the number of signature genes for each biological
condition and time (see \code{\link[=DEplotBarplotFacetGrid]{DEplotBarplotFacetGrid()}}).
\item a barplot showing the number of genes which are DE at least at one time,
specific at least at one time and signature at least at one time,
for each biological condition.
\item an alluvial graph of genes which are signature at least one time
(see \code{\link[=DEplotAlluvial]{DEplotAlluvial()}}).
}
}
}
\description{
The function realizes from the
\code{\link[DESeq2:DESeq]{DESeq2::DESeq()}}
output the analysis of :
\itemize{
\item DE genes between all pairs of biological conditions for each fixed time.
\item DE genes between all times ti and the reference time t0for each
biological condition.
}
}
\examples{
data(RawCounts_Schleiss2021_CLLsub500)
## We take only the first three times (both group) for the speed of
## the example
Index3t<-c(2:4,11:13,20:22, 29:31,38:40,47:49)
RawCounts_3t<-RawCounts_Schleiss2021_CLLsub500[seq_len(200), c(1,Index3t)]

## Preprocessing step
resDATAprepSEleuk <- DATAprepSE(RawCounts=RawCounts_3t,
                                Column.gene=1,
                                Group.position=2,
                                Time.position=4,
                                Individual.position=3)

DESeq2preprocess <- S4Vectors::metadata(resDATAprepSEleuk)$DESeq2obj
DESeq2obj <- DESeq2preprocess$DESeq2preproceesing

##------------------------------------------------------------------------##
dds.DE <- DESeq2::DESeq(DESeq2obj)
##
res.G.T <- DEanalysisTimeAndGroup(DESeq.result=dds.DE,
                                  LRT.supp.info=FALSE,
                                  pval.min=0.05,
                                  pval.vect.t=NULL,
                                  log.FC.min=0.1,
                                  Plot.DE.graph=TRUE,
                                  path.result=NULL,
                                  SubFile.name=NULL)
}
\seealso{
The outputs of the function will be used by the main
function \code{\link[=DEanalysisGlobal]{DEanalysisGlobal()}}.
}
