% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeplot.R
\name{makeplot}
\alias{makeplot}
\title{Making plots to visualize nonlinear associations}
\usage{
makeplot(object, phenoname, genename, ...)
}
\arguments{
\item{object}{a NBAMSeqDataSet object}

\item{phenoname}{the name of nonlinear variable to be visualized}

\item{genename}{the name of gene to be visualized}

\item{...}{additional arguments provided to \code{\link[mgcv]{plot.gam}}}
}
\value{
the plot made by plot.gam() function
}
\description{
This function makes plots to visualize nonlinear associations.
}
\examples{
gsd = makeExample(n = 3, m = 10)
gsd = NBAMSeq(gsd)
makeplot(gsd, "pheno", "gene3", main = "gene10")
}
