% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_methy.R
\name{filter_methy}
\alias{filter_methy}
\title{Create filtered methylation file}
\usage{
filter_methy(x, output_file, ...)
}
\arguments{
\item{x}{the path to the methylation file or a NanoMethResult object.}

\item{output_file}{the output file to write results to (must end in .bgz).}

\item{...}{filtering criteria given in dplyr syntax. Use methy_col_names()
to get available column names.}
}
\value{
invisibly returns 'output_file' if x is a file path, otherwise returns
NanoMethResult object with methy(x) replaced with filtered value.
}
\description{
Create a filtered methylation file from an existing one.
}
\examples{
nmr <- load_example_nanomethresult()
output_file <- paste0(tempfile(), ".tsv.bgz")
filter_methy(nmr, output_file = output_file, chr == "chrX")
filter_methy(methy(nmr), output_file = output_file, chr == "chrX")
}
