% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot_gene_heatmap.R
\name{plot_gene_heatmap}
\alias{plot_gene_heatmap}
\alias{plot_gene_heatmap,NanoMethResult,character-method}
\alias{plot_gene_heatmap,ModBamResult,character-method}
\title{Plot gene methylation heatmap}
\usage{
plot_gene_heatmap(x, gene, ...)

\S4method{plot_gene_heatmap}{NanoMethResult,character}(
  x,
  gene,
  window_prop = 0.3,
  pos_style = c("to_scale", "compact"),
  subsample = 50
)

\S4method{plot_gene_heatmap}{ModBamResult,character}(
  x,
  gene,
  window_prop = 0.3,
  pos_style = c("to_scale", "compact"),
  subsample = 50
)
}
\arguments{
\item{x}{the NanoMethResult or ModBamResult object.}

\item{gene}{the gene symbol for the gene to plot.}

\item{...}{additional arguments.}

\item{window_prop}{the size of flanking region to plot. Can be a vector of two
values for left and right window size. Values indicate proportion of gene
length.}

\item{pos_style}{the style for plotting the base positions along the x-axis.
Defaults to "to_scale", plotting (potentially) overlapping squares
along the genomic position to scale. The "compact" options plots only the
positions with measured modification.}

\item{subsample}{the number of read of packed read rows to subsample to.}
}
\value{
a ggplot object of the heatmap

a ggplot plot containing the heatmap.
}
\description{
Plot the methylation heatmap of a gene symbol specified within the exon(x) slot.
}
\details{
This function creates a heatmap visualization of methylation data for a specific gene.
Each row in the heatmap represents one or more packed reads, where colored segments
indicate methylation probability at each genomic position.
}
\examples{
nmr <- load_example_nanomethresult()
plot_gene_heatmap(nmr, "Peg3")

}
