% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deVolcano.R
\name{deVolcano}
\alias{deVolcano}
\title{Draw volcano plot of differential expression results}
\usage{
deVolcano(limmaResults, plotContrast = NULL, y.var = c("p.value", "q.value"))
}
\arguments{
\item{limmaResults}{Result from runLimmaAnalysis.}

\item{plotContrast}{Contrast to select for volcano plot. Should be one of the
columns in the limma coefficients matrix (for example, a sample group that
was compared against the base group, or one of the contrasts in the design
matrix). If NULL (default), will plot the first non-Intercept column from
the limma coefficients matrix.}

\item{y.var}{The variable to plot for the y axis, either "p.value" or
"q.value" (the false discovery adjusted p-value)}
}
\value{
A volcano plot using ggplot2
}
\description{
Draw a volcano plot for results of a differential expression analysis by
limma.
}
\examples{
data(ExampleResults) # Results from runLimmaAnalysis

deVolcano(ExampleResults, plotContrast = "Autoimmune.retinopathy")
}
