% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_methods.R
\name{newmodel}
\alias{newmodel}
\title{Initialize an object of class newmodel}
\usage{
newmodel(
  X,
  V,
  W,
  beta,
  gamma,
  alpha,
  zeta,
  epsilon,
  epsilon_beta,
  epsilon_gamma,
  epsilon_W,
  epsilon_alpha,
  epsilon_zeta,
  n,
  J,
  K
)
}
\arguments{
\item{X}{matrix. The design matrix containing sample-level covariates, one
sample per row.}

\item{V}{matrix. The design matrix containing gene-level covariates, one gene
per row.}

\item{W}{matrix. The factors of sample-level latent factors.}

\item{beta}{matrix or NULL. The coefficients of X in the regression of mu.}

\item{gamma}{matrix or NULL. The coefficients of V in the regression of
mu.}

\item{alpha}{matrix or NULL. The coefficients of W in the regression of
mu.}

\item{zeta}{numeric. A vector of log of inverse dispersion parameters.}

\item{epsilon}{nonnegative scalar. Regularization parameter.}

\item{epsilon_beta}{nonnegative scalar. Regularization parameter for
beta.}

\item{epsilon_gamma}{nonnegative scalar. Regularization parameter for
gamma.}

\item{epsilon_W}{nonnegative scalar. Regularization parameter for W.}

\item{epsilon_alpha}{nonnegative scalar. Regularization parameter for alpha}

\item{epsilon_zeta}{nonnegative scalar. Regularization parameter for zeta.}

\item{n}{integer. Number of samples.}

\item{J}{integer. Number of genes.}

\item{K}{integer. Number of latent factors.}
}
\value{
an object of class \code{\linkS4class{newmodel}}.
}
\description{
Initialize an object of class newmodel
}
\details{
This is a wrapper around the new() function to create an
 instance of class \code{newmodel}. Rarely, the user will need to create a
 \code{newmodel} object from scratch, as tipically this is the result of
 \code{\link{newFit}}.

If any of \code{X}, \code{V}, \code{W} matrices are passed,
 \code{n}, \code{J}, and \code{K} are inferred. Alternatively, the user can
 specify one or more of \code{n}, \code{J}, and \code{K}.

The regularization parameters can be set by a unique parameter
 \code{epsilon} or specific values for the different regularization
 parameters can also be provided.
 If only \code{epsilon} is specified, the other parameters take the
 following values:
 \itemize{
 \item epsilon_beta = epsilon/J
 \item epsilon_gamma = epsilon/n
 \item epsilon_W = epsilon/n
 \item epsilon_alpha = epsilon/J
 \item epsilon_zeta = epsilon
 }
 We empirically found that large values of \code{epsilon} provide a more
 stable estimation of \code{W}.

A call with no argument has the following default values: \code{n =
 50}, \code{J = 100}, \code{K = 0}, \code{epsilon=J}.

Although it is possible to create new instances of the class by
 calling this function, this is not the most common way of creating
 \code{newmodel} objects. The main use of the class is within the
 \code{\link{newFit}} function.
}
\examples{
a <- newmodel()
numberSamples(a)
numberFeatures(a)
numberFactors(a)
}
