% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/higherOrderNormMethods.R
\name{getSmoothedRTNormalizedMatrix}
\alias{getSmoothedRTNormalizedMatrix}
\title{Generate multiple RT time-window normalized matrices where one is shifted.
Merge them using a specified method (mean or median) and return the result.}
\usage{
getSmoothedRTNormalizedMatrix(
  rawMatrix,
  retentionTimes,
  normMethod,
  stepSizeMinutes,
  windowShifts = 2,
  windowMinCount = 100,
  mergeMethod = "mean",
  noLogTransform = FALSE
)
}
\arguments{
\item{rawMatrix}{Target matrix to be normalized}

\item{retentionTimes}{Vector of retention times corresponding to rawMatrix}

\item{normMethod}{The normalization method to apply to the time windows}

\item{stepSizeMinutes}{Size of windows to be normalized}

\item{windowShifts}{Number of frame shifts.}

\item{windowMinCount}{Minimum number of features within window.}

\item{mergeMethod}{Layer merging approach. Mean or median.}

\item{noLogTransform}{Don't log transform the input}
}
\value{
Normalized matrix
}
\description{
Uses the function getRTNormalizedMatrix to generate multiple normalized
matrices which are shifted respective to each other and finally merged into
a single matrix. This could potentially reduce effect of fluctuations
within individual windows.
}
\examples{

data(example_data_small)
data(example_data_only_values)
data(example_design_small)
retentionTimes <- as.numeric(example_data[, "Average.RT"])
dataMat <- example_data_only_values
performCyclicLoessNormalization <- function(rawMatrix) {
    log2Matrix <- log2(rawMatrix)
    normMatrix <- limma::normalizeCyclicLoess(log2Matrix, method="fast")
    colnames(normMatrix) <- colnames(rawMatrix)
    normMatrix
}
rtNormMat <- getSmoothedRTNormalizedMatrix(dataMat, retentionTimes, 
    performCyclicLoessNormalization, stepSizeMinutes=1, windowMinCount=100, 
    windowShifts=2, mergeMethod="median")
}
