% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findPTCs.r
\name{findPTCs}
\alias{findPTCs}
\title{Identify the premature termination codons in nucleotide sequences}
\usage{
findPTCs(orfs, gtf, workDir = NULL)
}
\arguments{
\item{orfs}{character string giving the name of tab-delimited TXT file with
coordinates of open reading frame(-s). This file should include four
mandatory fields:
i) transcript_id - transcript ID;
ii) start        - start coordinate of open reading frame
                   in a transcript;
iii) end         - end coordinate of open reading frame in a transcript;
iv) length       - length of open reading frame.}

\item{gtf}{character string giving the name of GTF/GFF file with annotated
transcripts of interest. Valid format is "gtf" or "gff".}

\item{workDir}{character string giving the path to and name of work
directory. NULL by default that mean the current working directory.}
}
\value{
data.frame object with start and stop positions, length and stop
    status of codons for each transcript ID.
}
\description{
Identify the premature termination codons in nucleotide
    sequences of interest.
}
\examples{
orfs_path <- system.file("extdata",
                         "Set.trans_ORFs.coordinates.txt",
                         package="ORFhunteR")
gtf_path <- system.file("extdata",
                        "Set.trans_sequences.gtf",
                        package="ORFhunteR")
ptcs <- findPTCs(orfs = orfs_path,
                  gtf = gtf_path,
                  workDir = NULL)
}
\author{
Vasily V. Grinev
}
