% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_imports.R
\name{readBamSeqs}
\alias{readBamSeqs}
\title{Read sequences from bam}
\usage{
readBamSeqs(path, yieldSize = NA_integer_)
}
\arguments{
\item{path}{path to bam file}

\item{yieldSize}{integer, default NA_integer_, number of reads to read in,
set to NA_integer_ to get full file.}
}
\value{
a DNAStringSet of length yieldSize (all in file if NA was specified)
}
\description{
The 'seq' flag of the bam, with a specified number of rows
}
\examples{
df <- ORFik.template.experiment.zf()
bam_file_path <- filepath(df, "default")
readBamSeqs(bam_file_path, 1e2)
}
