% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covRLE_class.R
\name{covRleFromGR}
\alias{covRleFromGR}
\title{Convert GRanges to covRle}
\usage{
covRleFromGR(x, weight = "AUTO", ignore.strand = FALSE)
}
\arguments{
\item{x}{a GRanges, GAlignment or GAlignmentPairs object.
Note that coverage calculation for GAlignment is slower, so usually best
to call convertToOneBasedRanges on GAlignment object to speed it up.}

\item{weight}{default "AUTO", pick 'score' column if exist, else all are 1L.
Can also be a manually assigned meta column like 'score2' etc.}

\item{ignore.strand}{logical, default FALSE.}
}
\value{
covRle object
}
\description{
Convert GRanges to covRle
}
\examples{
seqlengths <- as.integer(c(200, 300))
names(seqlengths) <- c("chr1", "chr2")
gr <- GRanges(seqnames = c("chr1", "chr1", "chr2", "chr2"),
               ranges = IRanges(start = c(10, 50, 100, 150), end = c(40, 80, 129, 179)),
               strand = c("+", "+", "-", "-"), seqlengths = seqlengths)
cov_both_strands <- covRleFromGR(gr)
cov_both_strands
cov_ignore_strand <- covRleFromGR(gr, ignore.strand = TRUE)
cov_ignore_strand
strandMode(cov_both_strands)
strandMode(cov_ignore_strand)
}
\seealso{
Other covRLE: 
\code{\link{covRle}},
\code{\link{covRle-class}},
\code{\link{covRleList}},
\code{\link{covRleList-class}}
}
\concept{covRLE}
