% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cage_annotations.R
\name{reassignTxDbByCage}
\alias{reassignTxDbByCage}
\title{Input a txdb and reassign the TSS for each transcript by CAGE}
\usage{
reassignTxDbByCage(
  txdb,
  cage,
  extension = 1000,
  filterValue = 1,
  restrictUpstreamToTx = FALSE,
  removeUnused = FALSE,
  preCleanup = TRUE
)
}
\arguments{
\item{txdb}{a TxDb file, a path to one of:
(.gtf ,.gff, .gff2, .gff2, .db or .sqlite)
or an ORFik experiment}

\item{cage}{Either a filePath for the CageSeq file as .bed .bam or .wig,
with possible compressions (".gzip", ".gz", ".bgz"), or already loaded
CageSeq peak data as GRanges or GAlignment.
NOTE: If it is a .bam file, it will add a score column by running:
convertToOneBasedRanges(cage, method = "5prime", addScoreColumn = TRUE)
The score column is then number of replicates of read, if score column is
something else, like read length, set the score column to NULL first.}

\item{extension}{The maximum number of basses upstream of the TSS to search
for CageSeq peak.}

\item{filterValue}{The minimum number of reads on cage position, for it to
be counted as possible new tss. (represented in score column in
CageSeq data) If you already filtered, set it to 0.}

\item{restrictUpstreamToTx}{a logical (FALSE). If TRUE: restrict leaders to
not extend closer than 5 bases from closest upstream leader, set this
to TRUE.}

\item{removeUnused}{logical (FALSE), if False:  (standard is to set them to
original annotation), If TRUE: remove leaders that did not have any cage
support.}

\item{preCleanup}{logical (TRUE), if TRUE,
remove all reads in region (-5:-1, 1:5) of all original tss in leaders.
This is to keep original TSS if it is only +/- 5 bases from the original.}
}
\value{
a TxDb obect of reassigned transcripts
}
\description{
Given a TxDb object, reassign the start site per transcript
using max peaks from CageSeq data. A max peak is defined as new
TSS if it is within boundary of 5' leader range, specified by
`extension` in bp. A max peak must also be higher than minimum
CageSeq peak cutoff specified in `filterValue`. The new TSS will then
be the positioned where the cage read (with highest read count in the
interval).
}
\details{
Note: If you used CAGEr, you will get reads of a probability region, with
always score of 1. Remember then to set filterValue to 0. And you should use
the 5' end of the read as input, use: ORFik:::convertToOneBasedRanges(cage)
}
\examples{
 \dontrun{
 library(GenomicFeatures)
 # Get the gtf txdb file
 txdbFile <- system.file("extdata", "hg19_knownGene_sample.sqlite",
 package = "GenomicFeatures")
 cagePath <- system.file("extdata", "cage-seq-heart.bed.bgz",
 package = "ORFik")
 reassignTxDbByCage(txdbFile, cagePath)
 }
}
\seealso{
Other CAGE: 
\code{\link{assignTSSByCage}()},
\code{\link{reassignTSSbyCage}()}
}
\concept{CAGE}
