% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shift_footprints.R
\name{shiftFootprintsByExperiment}
\alias{shiftFootprintsByExperiment}
\title{Shift footprints of each file in experiment}
\usage{
shiftFootprintsByExperiment(
  df,
  out.dir = pasteDir(libFolder(df), "/pshifted/"),
  start = TRUE,
  stop = FALSE,
  top_tx = 10L,
  minFiveUTR = 30L,
  minCDS = 150L,
  minThreeUTR = if (stop) {
     30
 } else NULL,
  firstN = 150L,
  min_reads = 1000,
  min_reads_TIS = 50,
  accepted.lengths = 26:34,
  output_format = c("ofst", "wig"),
  BPPARAM = bpparam(),
  tx = NULL,
  shift.list = NULL,
  log = TRUE,
  heatmap = FALSE,
  must.be.periodic = TRUE,
  strict.fft = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{df}{an ORFik \code{\link{experiment}}}

\item{out.dir}{output directory for files,
default: pasteDir(libFolder(df), "/pshifted/"),
making a /pshifted folder inside default bam file location}

\item{start}{(logical) Whether to include predictions based on the start
codons. Default TRUE.}

\item{stop}{(logical) Whether to include predictions based on the stop
codons. Default FASLE. Only use if there exists 3' UTRs for the annotation.
If peridicity around stop codon is stronger than at the start codon, use
stop instead of start region for p-shifting.}

\item{top_tx}{(integer), default 10. Specify which \% of the top TIS coverage
transcripts to use for estimation of the shifts. By default we take top 10%
top covered transcripts as they represent less noisy data-set. This is only
applicable when there are more than 1000 transcripts.}

\item{minFiveUTR}{(integer) minimum bp for 5' UTR during filtering for the
transcripts. Set to NULL if no 5' UTRs exists for annotation.}

\item{minCDS}{(integer) minimum bp for CDS during filtering for the
transcripts}

\item{minThreeUTR}{(integer) minimum bp for 3' UTR during filtering for the
transcripts. Set to NULL if no 3' UTRs exists for annotation.}

\item{firstN}{(integer) Represents how many bases of the transcripts
downstream of start codons to use for initial estimation of the
periodicity.}

\item{min_reads}{default (1000), how many reads must a read-length have in total
to be considered for periodicity.}

\item{min_reads_TIS}{default (50), how many reads must a read-length have in the
TIS region to be considered for periodicity.}

\item{accepted.lengths}{accepted read lengths, default 26:34, usually ribo-seq
is strongest between 27:32.}

\item{output_format}{default c("ofst", "wig"), use export.ofst or
wiggle format (wig) using \code{\link{export.wiggle}} ? Default is both.\cr
Options are: c("ofst", "bigWig", "wig", "bed", "bedo")
For future coverage per nucleotide, we advice to do here ofst and bigWig
for other genome browsers,
then call \code{\link{convert_to_covRleList}} to get much faster R objects.\cr
The wig format version can be used in IGV, the score column is counts of that
read with that read length, the cigar reference width is lost,
ofst is much faster to save and load in R, and retain cigar reference width,
but can not be used in IGV. \cr Also for larger tracks, you can use "bigWig".}

\item{BPPARAM}{how many cores/threads to use? default: bpparam()}

\item{tx}{a GRangesList, if you do not have 5' UTRs in annotation, send
your own version. Example: extendLeaders(tx, 30)
Where 30 bases will be new "leaders". Since each original transcript was
either only CDS or non-coding (filtered out).}

\item{shift.list}{default NULL, or a list containing named data.frames / data.tables
with minimum 2 columns, fraction (selected read lengths) and
offsets_start (relative position in nt). 1 named data.frame / data.table per library.
Output from \code{\link{detectRibosomeShifts}}.\cr
Run \code{ORFik::shifts_load(df)} for an example of input. The names of the list must
be the file.paths of the Ribo-seq libraries. Use this to edit the shifts, if
you suspect some of them are wrong in an experiment.\cr Can be a subset of libraries,
i.e. all other libraries will use auto-detect.}

\item{log}{logical, default (TRUE), output a log file with parameters used and
a .rds file with all shifts per library
(can be loaded with \code{\link{shifts_load}})}

\item{heatmap}{a logical or character string, default FALSE.
If TRUE, will plot heatmap of
raw reads before p-shifting to console, to see if shifts given make sense.
You can also set a filepath to save the file there.}

\item{must.be.periodic}{logical TRUE, if FALSE will not filter on
periodic read lengths. (The Fourier transform filter will be skipped).
This is useful if you are not going to do periodicity analysis, that is:
for you more coverage depth (more read lengths)
is more important than only keeping the high quality periodic read lengths.}

\item{strict.fft}{logical, TRUE. Use a FFT without noise filter.
This means keep only reads lengths that are "periodic for the human eye".
If you want more coverage, set to FALSE, to also get read lengths
that are "messy", but the noise filter detects the periodicity of 3.
This should only be done when you do not need high quality
periodic reads! Example would be differential translation analysis by
counts over each ORF.}

\item{verbose}{logical, default FALSE.
Report details of analysis/periodogram. Good if you are not sure
if the analysis was correct.}
}
\value{
NULL (Objects are saved to out.dir/pshited/"name_pshifted.ofst",
wig, bedo or .bedo)
}
\description{
A function that combines the steps of periodic read length detection,
p-site shift detection and p-shifting into 1 function.
For more details, see: \code{\link{detectRibosomeShifts}}\cr
Saves files to a specified location as .ofst and .wig,
The .ofst file will include a 'score' column with read count at that
position per read width (read width column is called 'size')  \cr
The .wig files, will be saved in pairs of +/- strand, and score column
will be replicates of reads starting at that position,
score = 5 means 5 reads.\cr
Remember that different species might have different default Ribosome
read lengths, for human, mouse etc, normally around 27:30.
}
\examples{
df <- ORFik.template.experiment.zf()
df <- df[1,] #lets only p-shift first RFP sample
## Output files as both .ofst and .wig(can be viewed in IGV/UCSC)
shiftFootprintsByExperiment(df)
# If you only need in R, do: (then you get no .wig files)
#shiftFootprintsByExperiment(df, output_format = "ofst")
## With debug info:
#shiftFootprintsByExperiment(df, verbose = TRUE)
## Re-shift, if you think some are wrong
## Here as an example we update library 1, third read length to shift 12
shift.list <- shifts_load(df)
shift.list[[1]]$offsets_start[3] <- -12
#shiftFootprintsByExperiment(df, shift.list = shift.list)
## For additional speedup in R for nucleotide coverage (coveragePerTiling etc)

}
\references{
https://bmcgenomics.biomedcentral.com/articles/10.1186/s12864-018-4912-6
}
\seealso{
Other pshifting: 
\code{\link{changePointAnalysis}()},
\code{\link{detectRibosomeShifts}()},
\code{\link{shiftFootprints}()},
\code{\link{shiftPlots}()},
\code{\link{shifts_load}()},
\code{\link{shifts_save}()}
}
\concept{pshifting}
