% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiment_plots.R
\name{transcriptWindowPer}
\alias{transcriptWindowPer}
\title{Helper function for transcriptWindow}
\usage{
transcriptWindowPer(
  leaders,
  cds,
  trailers,
  df,
  outdir = NULL,
  scores = c("sum", "zscore"),
  reads,
  returnCoverage = FALSE,
  windowSize = 100,
  drop.zero.dt = TRUE,
  BPPARAM = bpparam()
)
}
\arguments{
\item{leaders}{a \code{\link{GRangesList}} of leaders (5' UTRs)}

\item{cds}{a \code{\link{GRangesList}} of coding sequences}

\item{trailers}{a \code{\link{GRangesList}} of trailers (3' UTRs)}

\item{df}{an ORFik \code{\link{experiment}}}

\item{outdir}{directory to save to (default: NULL, no saving)}

\item{scores}{scoring function (default: c("sum", "transcriptNormalized")),
see ?coverageScorings for possible scores.}

\item{reads}{a GRanges / GAligment object of reads, can also be a list of those.}

\item{returnCoverage}{return data.table with coverage (default: FALSE)}

\item{windowSize}{size of binned windows, default: 100}

\item{drop.zero.dt}{logical FALSE, if TRUE and as.data.table is TRUE,
remove all 0 count positions.
This greatly speeds up and most importantly, greatly reduces memory usage.
Will not change any plots, unless 0 positions are used in some sense.
(mean, median, zscore coverage will only scale differently)}

\item{BPPARAM}{how many cores/threads to use? default: bpparam()}
}
\value{
NULL, or ggplot object if returnPlot is TRUE
}
\description{
Make 100 bases size meta window for one library in experiment
}
\details{
Gives you binned meta coverage plots, either saved seperatly or
all in one.
}
\seealso{
Other experiment plots: 
\code{\link{transcriptWindow}()},
\code{\link{transcriptWindow1}()}
}
\concept{experiment plots}
\keyword{internal}
