% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/method-evaluation.R
\name{aberrant}
\alias{aberrant}
\alias{aberrant,OutriderDataSet-method}
\title{Number of aberrant events}
\usage{
aberrant(object, ...)

\S4method{aberrant}{OutriderDataSet}(
  object,
  padjCutoff = 0.05,
  zScoreCutoff = 0,
  by = c("none", "sample", "gene"),
  subsetName = NULL,
  ...
)
}
\arguments{
\item{object}{An OutriderDataSet object}

\item{...}{Currently not in use.}

\item{padjCutoff}{The padjust cutoff}

\item{zScoreCutoff}{The absolute Z-score cutoff, 
if NA or NULL no Z-score cutoff is used}

\item{by}{if the results should be summarized by 'sample', 
'gene' or not at all (default).}

\item{subsetName}{The name of a subset of genes of interest for which FDR 
corected pvalues were previously computed. Those FDR values 
on the subset will then be used to determine aberrant status. 
Default is NULL (using transcriptome-wide FDR corrected pvalues).}
}
\value{
The number of aberrent events by gene or sample or a TRUE/FALSE 
            matrix of the size sample x gene of aberrent events.
}
\description{
Identifies the aberrant events and returns the number of aberrant counts per
gene or sample or returns a matrix indicating aberrant events.
}
\examples{
ods <- makeExampleOutriderDataSet()
ods <- OUTRIDER(ods, implementation='pca')

aberrant(ods)[1:10,1:10]
tail(sort(aberrant(ods, by="sample")))
tail(sort(aberrant(ods, by="gene")))

}
