% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/id_mapping.R
\name{ensembl_id_mapping_table}
\alias{ensembl_id_mapping_table}
\title{Identifier translation table from Ensembl}
\usage{
ensembl_id_mapping_table(to, from = "uniprot", organism = 9606)
}
\arguments{
\item{to}{Character or symbol: target ID type. See Details for possible
values.}

\item{from}{Character or symbol: source ID type. See Details for possible
values.}

\item{organism}{Character or integer: NCBI Taxonomy ID or name of the
organism (by default 9606 for human).}
}
\value{
A data frame (tibble) with columns `From` and `To`.
}
\description{
Identifier translation table from Ensembl
}
\details{
The arguments \code{to} and \code{from} can be provided either
as character or as symbol (NSE). Their possible values are either Ensembl
attribute names or synonyms listed at \code{\link{translate_ids}}.
}
\examples{
ensp_up <- ensembl_id_mapping_table("ensp")
ensp_up
# # A tibble: 119,129 × 2
#    From   To
#    <chr>  <chr>
#  1 P03886 ENSP00000354687
#  2 P03891 ENSP00000355046
#  3 P00395 ENSP00000354499
#  4 P00403 ENSP00000354876
#  5 P03928 ENSP00000355265
# # . with 119,124 more rows

}
\seealso{
\itemize{
    \item{\code{\link{translate_ids}}}
    \item{\code{\link{uniprot_full_id_mapping_table}}}
    \item{\code{\link{uniprot_id_mapping_table}}}
    \item{\code{\link{hmdb_id_mapping_table}}}
    \item{\code{\link{chalmers_gem_id_mapping_table}}}
}
}
