% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{evidences}
\alias{evidences}
\title{Show evidences for an interaction}
\usage{
evidences(
  partner_a,
  partner_b,
  interactions = NULL,
  directed = FALSE,
  open = TRUE,
  browser = NULL,
  max_pages = 25L
)
}
\arguments{
\item{partner_a}{Identifier or name of one interacting partner. The order
of the partners matter only if `directed` is `TRUE`. For both partners,
vectors of more than one identifiers can be passed.}

\item{partner_b}{Identifier or name of the other interacting partner.}

\item{interactions}{An interaction data frame. If not provided, all
interactions will be loaded within this function, but that takes
noticeable time. If a `list` is provided, it will be used as
parameters for \code{\link{omnipath_interactions}}. This way
you can define the organism, datasets or the interaction type.}

\item{directed}{Logical: does the direction matter? If `TRUE`, only
a → b interactions will be shown.}

\item{open}{Logical: open online articles in a web browser.}

\item{browser}{Character: override the web browser executable used
to open online articles.}

\item{max_pages}{Numeric: largest number of pages to open. This is to
prevent opening hundreds or thousands of pages at once.}
}
\value{
Nothing.
}
\description{
Show evidences for an interaction
}
\details{
If the number of references is larger than `max_pages`, the most recent
ones will be opened. URLs are passed to the browser in order of decreasing
publication date, though browsers do not seem to respect the order at all.
In addition Firefox, if it's not open already, tends to randomly open empty
tab for the first or last URL, have no idea what to do about it.
}
\examples{
\dontrun{
evidences('CALM1', 'TRPC1', list(datasets = 'omnipath'))
}

}
