% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nichenet.R
\name{nichenet_gr_network_remap}
\alias{nichenet_gr_network_remap}
\title{NicheNet gene regulatory network from ReMap}
\usage{
nichenet_gr_network_remap(
  score = 100,
  top_targets = 500,
  only_known_tfs = TRUE
)
}
\arguments{
\item{score}{Numeric: a minimum score between 0 and 1000, records with
lower scores will be excluded. If NULL no filtering performed.}

\item{top_targets}{Numeric: the number of top scoring targets for each
TF. Essentially the maximum number of targets per TF. If NULL the
number of targets is not restricted.}

\item{only_known_tfs}{Logical: whether to exclude TFs which are not in
TF census.}
}
\value{
Data frame with gene regulatory interactions in NicheNet format.
}
\description{
Builds a gene regulatory network using data from the ReMap database
and converts it to a format suitable for NicheNet.
}
\examples{
# use only max. top 100 targets for each TF:
remap_gr_network <- nichenet_gr_network_remap(top_targets = 100)

}
\seealso{
\itemize{
    \item{\code{\link{remap_filtered}}}
    \item{\code{\link{nichenet_gr_network}}}
}
}
