% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nichenet.R
\name{nichenet_signaling_network_pathwaycommons}
\alias{nichenet_signaling_network_pathwaycommons}
\title{NicheNet signaling network from PathwayCommons}
\usage{
nichenet_signaling_network_pathwaycommons(
  interaction_types = c("catalysis-precedes", "controls-phosphorylation-of",
    "controls-state-change-of", "controls-transport-of", "in-complex-with",
    "interacts-with"),
  ...
)
}
\arguments{
\item{interaction_types}{Character vector with PathwayCommons interaction
types. Please refer to the default value and the PathwayCommons
webpage.}

\item{...}{Ignored.}
}
\value{
A network data frame (tibble) with signaling interactions
    suitable for use with NicheNet.
}
\description{
Builds signaling network prior knowledge for NicheNet using PathwayCommons.
}
\examples{
# use only the "controls-transport-of" interactions:
pc_signaling_network <- nichenet_signaling_network_pathwaycommons(
    interaction_types = 'controls-transport-of'
)

}
