% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ontology.R
\name{relations_table_to_list}
\alias{relations_table_to_list}
\title{Nested list from a table of ontology relations}
\usage{
relations_table_to_list(relations)
}
\arguments{
\item{relations}{A data frame of ontology relations (the "relations"
element of the list returned by \code{\link{obo_parser}} in case
its argument `tables` is \code{TRUE}).}
}
\value{
The relations converted to a nested list.
}
\description{
Nested list from a table of ontology relations
}
\examples{
goslim_url <-
    "http://current.geneontology.org/ontology/subsets/goslim_generic.obo"
path <- tempfile()
curl::curl_fetch_disk(goslim_url, path)
obo <- obo_parser(path, tables = TRUE)
unlink(path)
rel_list <- relations_table_to_list(obo$relations)

}
\seealso{
\itemize{
    \item{\code{\link{relations_list_to_table}}}
    \item{\code{\link{swap_relations}}}
    \item{\code{\link{obo_parser}}}
}
}
