% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ontology.R
\name{swap_relations}
\alias{swap_relations}
\title{Reverse the direction of ontology relations}
\usage{
swap_relations(relations)
}
\arguments{
\item{relations}{The `relations` component of the data returned by
\code{\link{obo_parser}} or any `...ontology_download` function
such as \code{\link{go_ontology_download}}. Depending on the
\code{tables} argument of those functions the `relations` can be
a data frame or a nested list.}
}
\value{
Same type as the input, but the relations swapped: if in the input
    these pointed from each child to the parents, in the output they
    point from each parent to their children, and vice versa.
}
\description{
Reverse the direction of ontology relations
}
\examples{
goslim_url <-
    "http://current.geneontology.org/ontology/subsets/goslim_generic.obo"
path <- tempfile()
curl::curl_fetch_disk(goslim_url, path)
obo <- obo_parser(path)
unlink(path)
rel_swapped <- swap_relations(obo$relations)

}
\seealso{
\itemize{
    \item{\code{\link{relations_list_to_table}}}
    \item{\code{\link{relations_table_to_list}}}
    \item{\code{\link{obo_parser}}}
}
}
