% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-PCOSP.R
\name{PCOSP}
\alias{PCOSP}
\title{Pancreatic Cancer Overall Survival Predictor (PCOSP) Constructor}
\usage{
PCOSP(trainCohorts, minDaysSurvived = 365, ..., randomSeed)
}
\arguments{
\item{trainCohorts}{A \code{CohortList} or \code{SurivalExperiment} containing the
training data for the \code{PCOSP} model.}

\item{minDaysSurvived}{An \code{integer} indicating the minimum number of day
required to be in the 'good' survival group. Any patients below this
cut-off will be considered low survival. Default is 365 days.}

\item{...}{Force subsequent parameters to be named. This parameter is not
used.}

\item{randomSeed}{An \code{integer} randomSeed that was used to train the model.
Users should specify this when initializing a model to ensure
reproducibilty.}
}
\value{
A \code{PCOSP} object with training data in the assays slot, concatenating
together the molecular data types and labelling the genes with the data
type to ensure the results are easily interpretable.
}
\description{
Pancreatic Cancer Overall Survival Predictor (PCOSP) Constructor
}
\details{
This function assumes there is only 1 assay per
\code{SurvivalExperiment}.
}
\examples{
data(sampleICGCmicro)
set.seed(1987)
PCOSPmodel <- PCOSP(sampleICGCmicro, minDaysSurvived=365, randomSeed=1987)

}
