% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-assignSubtypes.R
\name{assignSubtypes,SurvivalExperiment,data.frame-method}
\alias{assignSubtypes,SurvivalExperiment,data.frame-method}
\title{Assign Subtype Annotations to a SurvivalExperiment Object}
\usage{
\S4method{assignSubtypes}{SurvivalExperiment,data.frame}(
  object,
  subtypes,
  ...,
  sampleCol = "sample_name",
  subtypeCol = "subtype"
)
}
\arguments{
\item{object}{A \code{SurvivalExperiment} object where the subtype annotations
will be added to the \code{colData} slot as the \code{subtype} column.}

\item{subtypes}{A \code{data.frame} with}

\item{...}{Force subsequent arguments to be named. Not used.}

\item{sampleCol}{A \code{character} vector specifying the name of the column
containing the sample names. These must match the colnames of the
\code{SurvivalExperiment}. If the sample names are the rownames of the \code{subtypes}
\code{data.frame} then set this parameter to 'rownames'. Defaults to 'sample_name'.}

\item{subtypeCol}{A \code{character} vector specifying the name of the subtype
column in the \code{subtypes} \code{data.frame} object. Defaults to 'subtype'.}
}
\value{
The \code{SurvivalExperiment} with the subtypes in the \code{subtypes} column
of the colData slot and a metadata item, \code{hasSubtypes}, set to TRUE.
}
\description{
Assign Subtype Annotations to a SurvivalExperiment Object
}
\examples{
data(sampleICGCmicro)
data(cohortSubtypeDFs)

cohortList <- assignSubtypes(sampleICGCmicro,
  subtypes=cohortSubtypeDFs$ICGCMICRO,
  sampleCol='sample_name',
  subtypeCol='subtype')


}
