% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-compareModels.R
\name{compareModels}
\alias{compareModels}
\title{Compare Two Mathematical Models Represented as \code{S4} Objects}
\usage{
compareModels(model1, model2, ...)
}
\arguments{
\item{model1}{A \code{S4} object representing some kind of mathematical model.}

\item{model2}{A \code{S4} object representing some kind of mathematical model.}

\item{...}{Allow new parameters to be defined for this generic.}
}
\value{
A \code{S4} object with statistics about the performance of each model.
}
\description{
Compare Two Mathematical Models Represented as \code{S4} Objects
}
\examples{
data(sampleValPCOSPmodel)
data(sampleClinicalModel)
data(sampleCohortList)

# Set parallelization settings
BiocParallel::register(BiocParallel::SerialParam())

# Train the model
trainedClinicalModel <- trainModel(sampleClinicalModel)

# Predict risk/risk-class
ClinicalPredPCSI <- predictClasses(sampleCohortList[c('PCSI', 'TCGA')],
  model=trainedClinicalModel)

# Validate the models
validatedClinicalModel <- validateModel(trainedClinicalModel,
  valData=ClinicalPredPCSI)

# Compare the models
modelComp <- compareModels(sampleValPCOSPmodel, validatedClinicalModel)
head(modelComp)

}
