% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-merge.R
\name{merge,SurvivalExperiment,SurvivalExperiment-method}
\alias{merge,SurvivalExperiment,SurvivalExperiment-method}
\title{Merge two \code{SurvivalExperiments}, subsetting to shared rows and columns}
\usage{
\S4method{merge}{SurvivalExperiment,SurvivalExperiment}(x, y, cohortNames)
}
\arguments{
\item{x}{A \code{SurvivalExperiment}.}

\item{y}{A \code{SurvivalExperiment}.}

\item{cohortNames}{An optional \code{character} vector specifying the a name for
each \code{SurvivalExperiment}.}
}
\value{
A \code{SurvivalExperiment} object with merge data from x and y, and
the assay from each in the \code{assays} slot.
}
\description{
Merge two \code{SurvivalExperiments}, subsetting to shared rows and columns
}
\examples{
data(sampleICGCmicro)
survExp2 <- sampleICGCmicro
mergedSurvExp <- merge(survExp2, sampleICGCmicro,
  cohortNames=c('copyICGCmicro', 'ICGCmicro'))
mergedSurvExp

}
