% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-trainModel.R
\name{trainModel,RLSModel-method}
\alias{trainModel,RLSModel-method}
\title{Train a PCOSP Model Based on The Data the assay \code{trainMatrix}.}
\usage{
\S4method{trainModel}{RLSModel}(object, numModels = 10, minAccuracy = 0, ...)
}
\arguments{
\item{object}{A \code{PCOSP} object to train.}

\item{numModels}{An \code{integer} specifying the number of models to train.
Defaults to 10. We recommend using 1000+ for good results.}

\item{minAccuracy}{This parameter should be set to zero, since we do
not expect the permuted models to perform well. Setting this higher will
result in an ensemble with very few models included.}

\item{...}{Fall through arguments to \code{BiocParallel::bplapply}. Use this to
configure parallelization options. By default the settings inferred in
\code{BiocParallel::bpparam()} will be used.}
}
\value{
A \code{PCOSP} object with the trained model in the \code{model} slot.
}
\description{
Uses the switchBox SWAP.Train.KTSP function to fit a number of k top scoring
pair models to the data, filtering the results to the best models based
on the specified paramters.
}
\details{
This function is parallelized with BiocParallel, thus if you wish
to change the back-end for parallelization, number of threads, or any
other parallelization configuration please pass BPPARAM to bplapply.
}
\examples{
data(sampleRLSmodel)
set.seed(getModelSeed(sampleRLSmodel))

# Set parallelization settings
BiocParallel::register(BiocParallel::SerialParam())

trainedRLSmodel <- trainModel(sampleRLSmodel, numModels=2)

}
\seealso{
switchBox::SWAP.KTSP.Train BiocParallel::bplapply
}
