% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PomaHeatmap.R
\name{PomaHeatmap}
\alias{PomaHeatmap}
\title{Heatmap Plot}
\usage{
PomaHeatmap(
  data,
  covs = NULL,
  sample_names = TRUE,
  feature_names = FALSE,
  show_legend = TRUE
)
}
\arguments{
\item{data}{A \code{SummarizedExperiment} object.}

\item{covs}{Character vector. Indicates the names of \code{colData} columns to be included as covariates. Default is NULL (no covariates).}

\item{sample_names}{Logical. Indicates if sample names should be displayed or not. Default is TRUE.}

\item{feature_names}{Logical. Indicates if feature names should be displayed or not. Default is FALSE.}

\item{show_legend}{Logical. Indicates if legend should be displayed or not. Default is TRUE.}
}
\value{
A \code{ggplot} object.
}
\description{
\code{PomaHeatmap} generates a heatmap.
}
\examples{
data <- POMA::st000284 \%>\% # Example SummarizedExperiment object included in POMA
  PomaNorm()

# Basic heatmap
data \%>\% 
  PomaHeatmap()

# Heatmap with one covariate  
data \%>\% 
  PomaHeatmap(covs = "factors")

# Heatmap with two covariates
data \%>\% 
  PomaHeatmap(covs = c("factors", "smoking_condition"))
}
\author{
Pol Castellano-Escuder
}
