% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PomaLM.R
\name{PomaLM}
\alias{PomaLM}
\title{Linear Models}
\usage{
PomaLM(data, x = NULL, y = NULL, adjust = "fdr")
}
\arguments{
\item{data}{A \code{SummarizedExperiment} object.}

\item{x}{Character vector. Indicates the names of independent variables. If it's NULL (default), all features will be used.}

\item{y}{Character. Indicates the name of \code{colData} numeric columns to be used as dependent variable. If it's set to NULL, the first numeric variable in \code{colData} will be used as the dependent variable.}

\item{adjust}{Character. Multiple comparisons correction method to adjust p-values. Available options are: "fdr" (false discovery rate), "holm", "hochberg", "hommel", "bonferroni", "BH" (Benjamini-Hochberg), and "BY" (Benjamini-Yekutieli).}
}
\value{
A \code{list} with results including plots and tables.
}
\description{
\code{PomaLM} performs a linear model on a \code{SummarizedExperiment} object.
}
\examples{
data <- POMA::st000284 \%>\% # Example SummarizedExperiment object included in POMA
  PomaImpute() \%>\% 
  PomaNorm()

## Output is a list with objects `lm_table` (tibble) and `regression_plot` (ggplot2 object)
# Perform linear model with all features
data \%>\% 
  PomaLM()

# Perform linear model with two features
data \%>\% 
  PomaLM(x = c("x1_methyladenosine", "x2_deoxyuridine"))
}
\author{
Pol Castellano-Escuder
}
