% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PomaOutliers.R
\name{PomaOutliers}
\alias{PomaOutliers}
\title{Analyse and Remove Statistical Outliers}
\usage{
PomaOutliers(
  data,
  method = "euclidean",
  type = "median",
  outcome = NULL,
  coef = 2,
  labels = FALSE
)
}
\arguments{
\item{data}{A \code{SummarizedExperiment} object.}

\item{method}{Character. Indicates the distance measure method to perform MDS.}

\item{type}{Character. Indicates the type of outlier analysis to perform. Options are "median" (default) and "centroid". See \code{vegan::betadisper}.}

\item{outcome}{Character. Indicates the name of the \code{colData} column to be used as the outcome factor. Default is NULL (first factor variable in \code{colData}).}

\item{coef}{Numeric. Indicates the outlier coefficient. Lower values are more sensitive to outliers while higher values are less restrictive about outliers.}

\item{labels}{Logical. Indicates if sample names should to be plotted.}
}
\value{
A \code{list} with the results.
}
\description{
\code{PomaOutliers} analyses and removes statistical outliers from the data.
}
\examples{
data <- POMA::st000336 \%>\% # Example SummarizedExperiment object included in POMA
  PomaImpute() \%>\% 
  PomaNorm()

## Output is a list with objects `polygon_plot` (ggplot2 object), `distance_boxplot` (ggplot2 object), `outliers` (tibble), and `data` (outlier-free SummarizedExperiment)
outlier_results <- data \%>\% 
  PomaOutliers(method = "euclidean",
               type = "median",
               outcome = NULL,
               coef = 2,
               labels = FALSE)

outlier_results$data # cleaned SummarizedExperiment object

## Change oulier group factor
outlier_results2 <- data \%>\% 
  PomaOutliers(method = "euclidean",
               type = "median",
               outcome = "steroids",
               coef = 2,
               labels = FALSE)

outlier_results2$data # cleaned SummarizedExperiment object
}
\author{
Pol Castellano-Escuder
}
