% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilterProteins.R
\name{filter_out_proteins_by_value}
\alias{filter_out_proteins_by_value}
\title{Remove proteins by value in specific column}
\usage{
filter_out_proteins_by_value(se, column_name = "Reverse", values = c("+"))
}
\arguments{
\item{se}{SummarizedExperiment containing all necessary information of the proteomics data set}

\item{column_name}{name of column of which proteins with a specific value should be removed}

\item{values}{value of the column defining the proteins that should be removed}
}
\value{
filtered SummarizedExperiment object
}
\description{
Remove proteins by value in specific column
}
\examples{
data(tuberculosis_TMT_se)
tuberculosis_TMT_se <- filter_out_proteins_by_value(tuberculosis_TMT_se,
                                 column_name = "Reverse", values = c("+"))

}
