% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NormalizationMethods.R
\name{globalMeanNorm}
\alias{globalMeanNorm}
\title{Total Intensity Normalization Using the Mean for the Calculation of Scaling Factors}
\usage{
globalMeanNorm(se, ain = "raw", aout = "GlobalMean", on_raw = TRUE)
}
\arguments{
\item{se}{SummarizedExperiment containing all necessary information of the proteomics data set}

\item{ain}{String which assay should be used as input}

\item{aout}{String which assay should be used to save normalized data}

\item{on_raw}{Boolean specifying whether normalization should be performed on raw or log2-scaled data}
}
\value{
SummarizedExperiment containing the total intensity normalized data as assay (on log2 scale)
}
\description{
Intensities of each variable in a sample are divided with the sum of intensities
of all variables in the sample and multiplied with the mean of sum of intensities
of all variables in all samples. Raw data should be taken as input (on_raw = TRUE).
}
\examples{
data(tuberculosis_TMT_se)
tuberculosis_TMT_se <- globalMeanNorm(tuberculosis_TMT_se, ain = "raw",
                              aout = "GlobalMean", on_raw = TRUE)

}
