% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Imputation.R
\name{impute_se}
\alias{impute_se}
\title{Method to impute SummarizedExperiment. 
This method performs a mixed imputation on the proteins. It uses a k-nearest neighbor imputation for proteins with missing values at random (MAR) and imputes missing values by random draws from a left-shifted Gaussian distribution for proteins with missing values not at random (MNAR).}
\usage{
impute_se(se, ain = NULL, condition = NULL)
}
\arguments{
\item{se}{SummarizedExperiment containing all necessary information of the proteomics dataset}

\item{ain}{Vector of strings which assay should be used as input (default NULL).
If NULL then all normalization of the se object are plotted next to each other.}

\item{condition}{name of column of colData(se) representing the conditions of the data}
}
\value{
SummarizedExperiment with imputed intensities
}
\description{
Method to impute SummarizedExperiment. 
This method performs a mixed imputation on the proteins. It uses a k-nearest neighbor imputation for proteins with missing values at random (MAR) and imputes missing values by random draws from a left-shifted Gaussian distribution for proteins with missing values not at random (MNAR).
}
\examples{
data(tuberculosis_TMT_se)
tuberculosis_TMT_se <- remove_samples_manually(tuberculosis_TMT_se,
                          column = "Label", values = c("1.HC_Pool1"))
tuberculosis_TMT_se <- impute_se(tuberculosis_TMT_se, ain = NULL,
                          condition = NULL)

}
