% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEAnalysis.R
\name{run_DE_single}
\alias{run_DE_single}
\title{Run DE analysis on a single normalized data set}
\usage{
run_DE_single(
  se,
  method,
  comparisons,
  condition = NULL,
  DE_method = "limma",
  covariate = NULL,
  logFC = TRUE,
  logFC_up = 1,
  logFC_down = -1,
  p_adj = TRUE,
  alpha = 0.05,
  B = 100,
  K = 500,
  trend = TRUE,
  robust = TRUE,
  DEqMS_PSMs_column = NULL
)
}
\arguments{
\item{se}{SummarizedExperiment containing all necessary information of the proteomics data set}

\item{method}{String specifying which assay should be used as input}

\item{comparisons}{Vector of comparisons that are performed in the DE analysis (from specify_comparisons method)}

\item{condition}{column name of condition (if NULL, condition saved in SummarizedExperiment will be taken)}

\item{DE_method}{String specifying which DE method should be applied (limma, ROTS, DEqMS)}

\item{covariate}{String specifying which column to include as covariate into limma}

\item{logFC}{Boolean specifying whether to apply a logFC threshold (TRUE) or not (FALSE)}

\item{logFC_up}{Upper log2 fold change threshold (dividing into up regulated)}

\item{logFC_down}{Lower log2 fold change threshold (dividing into down regulated)}

\item{p_adj}{Boolean specifying whether to apply a threshold on adjusted p-values (TRUE) or on raw p-values (FALSE)}

\item{alpha}{Threshold for adjusted p-values or p-values}

\item{B}{Number of bootstrapping for ROTS}

\item{K}{Number of top-ranked features for reproducibility optimization}

\item{trend}{logical, should an intensity-dependent trend be allowed for the prior variance? If FALSE then the prior variance is constant. Alternatively, trend can be a row-wise numeric vector, which will be used as the covariate for the prior variance.}

\item{robust}{logical, should the estimation of df.prior and var.prior be robustified against outlier sample variances?}

\item{DEqMS_PSMs_column}{String specifying which column name to use for DEqMS (default NULL).  Any column of the rowData(se) is accepted.}
}
\value{
Data table of DE results
}
\description{
Run DE analysis on a single normalized data set
}
