% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConnectedComponent-class.R,
%   R/adjacencyMatrix-accessors.R
\name{ConnectedComponents}
\alias{ConnectedComponents}
\alias{ConnectedComponents-class}
\alias{length,ConnectedComponents}
\alias{adjacencyMatrix,ConnectedComponents}
\alias{ccMatrix}
\alias{show,ConnectedComponents}
\alias{connectedComponents}
\alias{[,ConnectedComponents,numeric,ANY,ANY}
\alias{[,ConnectedComponents,logical,ANY,ANY}
\alias{[,ConnectedComponents,integer,ANY,ANY}
\alias{dims,ConnectedComponents}
\alias{ncols,ConnectedComponents}
\alias{nrows,ConnectedComponents}
\alias{prioritiseConnectedComponents}
\alias{prioritizeConnectedComponents}
\alias{length,ConnectedComponents-method}
\alias{dims,ConnectedComponents-method}
\alias{ncols,ConnectedComponents-method}
\alias{nrows,ConnectedComponents-method}
\alias{[,ConnectedComponents,integer,ANY,ANY-method}
\alias{[,ConnectedComponents,logical,ANY,ANY-method}
\alias{[,ConnectedComponents,numeric,ANY,ANY-method}
\alias{adjacencyMatrix,ConnectedComponents-method}
\title{Connected components}
\usage{
ConnectedComponents(object, ...)

ccMatrix(x)

connectedComponents(x, i, simplify = TRUE)

\S4method{length}{ConnectedComponents}(x)

\S4method{dims}{ConnectedComponents}(x)

\S4method{ncols}{ConnectedComponents}(x)

\S4method{nrows}{ConnectedComponents}(x)

\S4method{[}{ConnectedComponents,integer,ANY,ANY}(x, i, j, ..., drop = FALSE)

\S4method{[}{ConnectedComponents,logical,ANY,ANY}(x, i, j, ..., drop = FALSE)

\S4method{[}{ConnectedComponents,numeric,ANY,ANY}(x, i, j, ..., drop = FALSE)

prioritiseConnectedComponents(x)

prioritizeConnectedComponents(x)

\S4method{adjacencyMatrix}{ConnectedComponents}(object)
}
\arguments{
\item{object}{For the \code{ConnectedComponents} class constructor,
either a sparse adjacency matrix of class \code{Matrix} or an
instance of class \code{PSM}.}

\item{...}{Additional arguments passed to
\code{\link[=makeAdjacencyMatrix]{makeAdjacencyMatrix()}} when \code{object} is of class \code{\link[=PSM]{PSM()}}.}

\item{x}{An object of class \code{ConnectedComponents}.}

\item{i}{\code{numeric()}, \code{integer()} or \code{logical()} to subset the
\code{ConnectedComponents} instance. If a \code{logical()}, it must be
of same length as the object is subsets.}

\item{simplify}{\code{logical(1)} if \code{TRUE} (default), the output is
simplified to sparse matrix if \code{i} was of length 1, otherwise
a \code{List} is returned. Always a \code{List} if \code{FALSE}.}

\item{j}{ignored}

\item{drop}{ignore}
}
\value{
The \code{ConnectedComponents()} constructor returns an
instance of class \code{ConnectedComponents}. The \emph{Creating and
manipulating objects} section describes the return values of
the functions that manipulate \code{ConnectedComponents} objects.
}
\description{
Connected components are a useful representation when exploring
identification data. They represent the relation between proteins
(the connected components) and how they form groups of proteins as
defined by shared peptides.

Connected components are stored as \code{ConnectedComponents} objects
that can be generated using the \code{ConnectedComponents()}
function.
}
\section{Slots}{

\describe{
\item{\code{adjMatrix}}{The sparse adjacency matrix (class \code{Matrix}) of
dimension \emph{p} peptides by \emph{m} proteins that was used to
generate the object.}

\item{\code{ccMatrix}}{The sparse connected components matrix (class
\code{Matrix}) of dimension \emph{m} by \emph{m} proteins.}

\item{\code{adjMatrices}}{A \code{List} containing adjacency matrices of each
connected components.}
}}

\section{Creating and manipulating objects}{

\itemize{
\item Instances of the class are created with the
\code{ConnectedComponent()} constructor from a \code{\link[=PSM]{PSM()}} object or
directly from a sparse adjacency matrix of class \code{Matrix}. Note
that if using the latter, the rows and columns must be named.
\item The sparse peptide-by-protein adjacency matrix is stored in the
\code{ConnectedComponent} instance and can be accessed with the
\code{adjacencyMatrix()} function.
\item The protein-by-protein connected components sparse matrix of
object \code{x} can be accessed with the \code{ccMatrix(x)} function.
\item The number of connected components of object \code{x} can be
retrieved with \code{length(x)}.
\item The size of the connected components of object \code{x}, i.e the
number of proteins in each component, can be retrieved with
\code{ncols(x)}. The number of peptides defining the connected
components can be retrieved with \code{nrows(x)}. Both can be
accessed with \code{dims(x)}.
\item The \code{connectedComponents(x, i, simplify = TRUE)} function
returns the peptide-by-protein sparse adjacency matrix (or
\code{List} of matrices, if \code{length(i) > 1}), i.e. the subset of the
adjacency matrix defined by the proteins in connected
component(s) \code{i}. \code{i} is the numeric index (between 1 and
\code{length(x)}) of the connected connected. If simplify is \code{TRUE}
(default), then a matrix is returned instead of a \code{List} of
matrices of length 1. If set to \code{FALSE}, a \code{List} is always
returned, irrespective of its length.
\item To help with the exploration of individual connected Components,
the \code{prioritiseConnectedComponents()} function will take an
instance of \code{ConnectedComponents} and return a \code{data.frame} where
the component indices are ordered based on their potential to
clean up/flag some peptides and split protein groups in small
groups or individual proteins, or simply explore them. The
prioritisation is based on a set of metrics computed from the
component's adjacency matrix, including its dimensions, row and
col sums maxima and minima, its sparsity and the number of
communities and their modularity that quantifies how well the
communities separate (see \code{\link[igraph:modularity.igraph]{igraph::modularity()}}. Note that
trivial components, i.e. those composed of a single peptide and
protein are excluded from the prioritised results. This
\code{data.frame} is ideally suited for a principal component
analysis (using for instance \code{\link[=prcomp]{prcomp()}}) for further inspection
for component visualisation with \code{\link[=plotAdjacencyMatrix]{plotAdjacencyMatrix()}}.
}
}

\examples{

## --------------------------------
## From an adjacency matrix
## --------------------------------
library(Matrix)
adj <- sparseMatrix(i = c(1, 2, 3, 3, 4, 4, 5),
                    j = c(1, 2, 3, 4, 3, 4, 5),
                    x = 1,
                    dimnames = list(paste0("Pep", 1:5),
                                   paste0("Prot", 1:5)))
adj
cc <- ConnectedComponents(adj)
cc

length(cc)
ncols(cc)

adjacencyMatrix(cc) ## same as adj above
ccMatrix(cc)

connectedComponents(cc)
connectedComponents(cc, 3) ## a singel matrix
connectedComponents(cc, 1:2) ## a List

## --------------------------------
## From an PSM object
## --------------------------------
f <- msdata::ident(full.names = TRUE, pattern = "TMT")
f

psm <- PSM(f) |>
       filterPsmDecoy() |>
       filterPsmRank()

cc <- ConnectedComponents(psm)
cc

length(cc)
table(ncols(cc))

(i <- which(ncols(cc) == 4))
ccomp <- connectedComponents(cc, i)

## A group of 4 proteins that all share peptide RTRYQAEVR
ccomp[[1]]

## Visualise the adjacency matrix - here, we see how the single
## peptides (white node) 'unites' the four proteins (blue nodes)
plotAdjacencyMatrix(ccomp[[1]])

## A group of 4 proteins formed by 7 peptides: THPAERKPRRRKKR is
## found in the two first proteins, KPTARRRKRK was found twice in
## ECA3389, VVPVGLRALVWVQR was found in all 4 proteins, KLKPRRR
## is specific to ECA3399, ...
ccomp[[3]]

## See how VVPVGLRALVWVQR is shared by ECA3406 ECA3415 ECA3389 and
## links the three other componennts, namely ECA3399, ECA3389 and
## (ECA3415, ECA3406). Filtering that peptide out would split that
## protein group in three.
plotAdjacencyMatrix(ccomp[[3]])

## Colour protein node based on protein names similarity
plotAdjacencyMatrix(ccomp[[3]], 1)

## To select non-trivial components of size > 1
cc2 <- cc[ncols(cc) > 1]
cc2

## Use components features to prioritise their exploration
pri_cc <- prioritiseConnectedComponents(cc)
pri_cc

plotAdjacencyMatrix(connectedComponents(cc, 1082), 1)
}
