% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{readPathoscopeData}
\alias{readPathoscopeData}
\title{Reads the data from PathoScope reports and returns a list of
final guess relative abundance and count data}
\usage{
readPathoscopeData(input_dir = ".",
  pathoreport_file_suffix = "-sam-report.tsv", use.input.files = FALSE,
  input.files.path.vec = NULL, input.files.name.vec = NULL)
}
\arguments{
\item{input_dir}{Directory where the tsv files from PathoScope are located}

\item{pathoreport_file_suffix}{PathoScope report files suffix}

\item{use.input.files}{whether input dir to pathoscope files
or directly pathoscope files}

\item{input.files.path.vec}{vector of pathoscope file paths}

\item{input.files.name.vec}{vector of pathoscope file names}
}
\value{
List of final guess relative abundance and count data
}
\description{
Reads the data from PathoScope reports and returns a list of
final guess relative abundance and count data
}
\examples{
example_data_dir <- system.file("example/data", package = "PathoStat")
pathoreport_file_suffix <- "-sam-report.tsv"
datlist <- readPathoscopeData(example_data_dir, pathoreport_file_suffix,
input.files.name.vec = as.character(1:6))
}
