% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignped4.R
\name{alignped4}
\alias{alignped4}
\title{Alignment fourth routine}
\usage{
alignped4(rval, spouse, level, width, align, precision = 4)
}
\arguments{
\item{rval}{A list with components \code{n}, \code{nid},
\code{pos}, and \code{fam}.}

\item{spouse}{A boolean matrix with one row per level representing if
the subject is a spouse or not.}

\item{level}{Vector of the level of each subject}

\item{width}{For a packed output, the minimum width of the plot, in
inches.}

\item{align}{For a packed Pedigree, align children under parents \code{TRUE},
to the extent possible given the page width, or align to to the left
margin \code{FALSE}.
This argument can be a two element vector, giving the alignment
parameters, or a logical value.
If \code{TRUE}, the default is \code{c(1.5, 2)}, or if numeric the routine
\code{alignped4()} will be called.}

\item{precision}{The number of significatif numbers to round the
solution to.}
}
\value{
The updated position matrix
}
\description{
Last routines which attempts to line up children under parents and put
spouses and siblings "close" to each other, to the extent possible
within the constraints of page width.
}
\details{
The \code{alignped4()} routine is the final step of alignment.
The current code does necessary setup and then calls the
\code{quadprog::solve.QP()} function.

There are two important parameters for the function:
\enumerate{
\item The maximum width specified.
The smallest possible width is the maximum number of subjects on a
line. If the user suggestion is too low it is increased to that
amount plus one (to give just a little wiggle room).
\item The align vector of 2 alignment parameters \code{a} and \code{b}.
For each set of siblings \code{x} with parents at \code{p_1} and \code{p_2}
the alignment penalty is:

\deqn{(1/k^a)\sum_{i=1}^{k} (x_i - (p_1 + p_2)/2)^2}

where \code{k} is the number of siblings in the set.
}

Using the fact that when \code{a = 1} :

\deqn{\sum(x_i-c)^2 = \sum(x_i-\mu)^2 + k(c-\mu)^2}

then moving a sibship with \code{k} sibs one unit to the left or
right of optimal will incur the same cost as moving one with only 1 or
two sibs out of place.

If \code{a = 0} then large sibships are harder to move
than small ones.
With the default value \code{a = 1.5}, they are slightly easier
to move than small ones.
The rationale for the default is as long as the
parents are somewhere between the first and last siblings the result looks
fairly good, so we are more flexible with the spacing of a large family.
By tethering all the sibs to a single spot they tend to be kept close to
each other.

The alignment penalty for spouses is \eqn{b(x_1 - x_2)^2}, which tends to
keep them together. The size of \code{b} controls the relative importance of
sib-parent and spouse-spouse closeness.
\enumerate{
\item We start by adding in these penalties.
The total number of parameters in the alignment problem
(what we hand to quadprog) is the set of \code{sum(n)} positions.
A work array myid keeps track of the parameter number for each position
so that it is easy to find. There is one extra penalty added at the end.
Because the penalty amount would be the same if all the final positions
were shifted by a constant, the penalty matrix will not be positive
definite; \code{solve.QP()} does not like this.
We add a tiny amount of leftward pull to the widest line.
\item If there are \code{k} subjects on a line there will
be \code{k+1} constraints for that line.  The first point must be
\eqn{\ge 0}, each subsequent one must be at least 1 unit to the right,
and the final point must be \eqn{\le} the max width.
}
}
\examples{
data(sampleped)
pedi <- Pedigree(sampleped)
align(pedi)

}
\seealso{
\code{\link[=align]{align()}}
}
\keyword{alignment}
\keyword{internal,}
