% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app_inf_sel.R
\name{inf_sel_ui}
\alias{inf_sel_ui}
\alias{inf_sel_server}
\alias{inf_sel_demo}
\title{Shiny module to select the informative individuals in a pedigree}
\usage{
inf_sel_ui(id)

inf_sel_server(id, pedi, help_colour = "grey")

inf_sel_demo(pedi)
}
\arguments{
\item{id}{A string to identify the module.}

\item{pedi}{A reactive pedigree object.}

\item{help_colour}{A string to define the colour of the help icon.}
}
\value{
A reactive pedigree object subselected from the
informative individuals.
}
\description{
This module allows to select informative individuals in a pedigree object.
They will be used to subset the pedigree object with the function
\code{useful_inds()}. Further filtering options are available (max kinship and
keep parents).
The function is composed of two parts: the UI and the server.
The UI is called with the function \code{inf_sel_ui()} and the server
with the function \code{inf_sel_server()}.
}
\examples{
if (interactive()) {
    data("sampleped")
    pedi <- shiny::reactive({
        Pedigree(sampleped[sampleped$famid == "1", ])
    })
    inf_sel_demo(pedi)
}
}
\keyword{internal}
