% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{parent_of}
\alias{parent_of}
\alias{parent_of,character_OR_integer-method}
\alias{parent_of,Ped-method}
\alias{parent_of,Pedigree-method}
\title{Get parents of individuals}
\usage{
\S4method{parent_of}{character_OR_integer}(obj, dadid, momid, id2)

\S4method{parent_of}{Ped}(obj, id2)

\S4method{parent_of}{Pedigree}(obj, id2)
}
\arguments{
\item{obj}{A character vector with the id of the individuals or a
\code{data.frame} with all the informations in corresponding columns.}

\item{dadid}{A vector containing for each subject, the identifiers of the
biologicals fathers.}

\item{momid}{A vector containing for each subject, the identifiers of the
biologicals mothers.}

\item{id2}{A vector of individuals identifiers to get the parents from}
}
\value{
A vector of individuals identifiers corresponding to the parents
of the individuals in \strong{id2}
}
\description{
Get the parents of individuals.
}
\examples{
data(sampleped)
ped <- Pedigree(sampleped)
parent_of(ped, "1_121")
}
